/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FilterUtils;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.builder.BFunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BTypeCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BVariableCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.MatchStatementResolverUtil;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class MatchStatementContextProvider
extends AbstractCompletionProvider {
    public MatchStatementContextProvider() {
        this.attachmentPoints.add(BallerinaParser.MatchStatementContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<CommonToken> defaultTokens = ((List)ctx.get(SourcePruneKeys.LHS_TOKENS_KEY)).stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        List defaultTokenTypes = defaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        int delimiter = (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (delimiter == 96) {
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> moduleContent = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(ctx);
            return this.getCompletionItemList(moduleContent, ctx);
        }
        if (delimiter > -1) {
            String varName = ((CommonToken)defaultTokens.get(defaultTokenTypes.indexOf(delimiter) - 1)).getText();
            List<Scope.ScopeEntry> filteredList = FilterUtils.filterVariableEntriesOnDelimiter(ctx, varName, delimiter, defaultTokens, defaultTokenTypes.lastIndexOf(delimiter));
            filteredList.removeIf(CommonUtil.invalidSymbolsPredicate());
            filteredList.forEach(scopeEntry -> {
                if (CommonUtil.isValidInvokableSymbol(scopeEntry.symbol)) {
                    BSymbol scopeEntrySymbol = scopeEntry.symbol;
                    completionItems.add(this.fillInvokableSymbolMatchSnippet((BInvokableSymbol)scopeEntrySymbol, ctx));
                }
            });
        } else {
            visibleSymbols.removeIf(CommonUtil.invalidSymbolsPredicate());
            visibleSymbols.forEach(scopeEntry -> {
                BSymbol bSymbol = scopeEntry.symbol;
                if (CommonUtil.isValidInvokableSymbol(scopeEntry.symbol) && (bSymbol.flags & 8) != 8) {
                    completionItems.add(this.fillInvokableSymbolMatchSnippet((BInvokableSymbol)bSymbol, ctx));
                } else if (!(scopeEntry.symbol instanceof BInvokableSymbol) && bSymbol instanceof BVarSymbol) {
                    this.fillVarSymbolMatchSnippet(ctx, (BVarSymbol)bSymbol, completionItems);
                    String typeName = scopeEntry.symbol.type.toString();
                    CompletionItem cItem = BVariableCompletionItemBuilder.build((BVarSymbol)bSymbol, scopeEntry.symbol.name.value, typeName);
                    completionItems.add(new SymbolCompletionItem(ctx, scopeEntry.symbol, cItem));
                } else if (bSymbol instanceof BPackageSymbol) {
                    CompletionItem cItem = BTypeCompletionItemBuilder.build(bSymbol, scopeEntry.symbol.name.getValue());
                    completionItems.add(new SymbolCompletionItem(ctx, scopeEntry.symbol, cItem));
                }
            });
        }
        return completionItems;
    }

    private LSCompletionItem getVariableCompletionItem(LSContext context, BVarSymbol varSymbol, String matchFieldSnippet, String label) {
        CompletionItem completionItem = BVariableCompletionItemBuilder.build(varSymbol, label, varSymbol.type.toString());
        completionItem.setInsertText(varSymbol.getName().getValue() + " " + matchFieldSnippet);
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        return new SymbolCompletionItem(context, (BSymbol)varSymbol, completionItem);
    }

    private String getFunctionSignature(BInvokableSymbol func) {
        String[] nameComps = func.getName().getValue().split("\\.");
        StringBuilder signature = new StringBuilder(nameComps[nameComps.length - 1]);
        ArrayList params = new ArrayList();
        signature.append("(");
        func.getParameters().forEach(bVarSymbol -> params.add(bVarSymbol.getName().getValue()));
        signature.append(String.join((CharSequence)",", params)).append(")");
        return signature.toString();
    }

    private LSCompletionItem fillInvokableSymbolMatchSnippet(BInvokableSymbol func, LSContext ctx) {
        String functionSignature = this.getFunctionSignature(func);
        String variableValuePattern = MatchStatementResolverUtil.getVariableValueDestructurePattern();
        String variableValueSnippet = this.generateMatchSnippet(variableValuePattern);
        CompletionItem completionItem = BFunctionCompletionItemBuilder.build(func, functionSignature, functionSignature + " " + variableValueSnippet, ctx);
        return new SymbolCompletionItem(ctx, (BSymbol)func, completionItem);
    }

    private void fillVarSymbolMatchSnippet(LSContext context, BVarSymbol varSymbol, List<LSCompletionItem> completionItems) {
        BType symbolType = varSymbol.getType();
        String varName = varSymbol.getName().getValue();
        if (symbolType instanceof BTupleType || symbolType instanceof BRecordType) {
            String fixedValuePattern = "\t" + MatchStatementResolverUtil.generateMatchPattern(MatchStatementResolverUtil.getStructuredFixedValueMatch(symbolType));
            String fixedValueSnippet = this.generateMatchSnippet(fixedValuePattern);
            completionItems.add(this.getVariableCompletionItem(context, varSymbol, fixedValueSnippet, varName));
        } else {
            String variableValuePattern = "\t" + MatchStatementResolverUtil.getVariableValueDestructurePattern();
            String variableValueSnippet = this.generateMatchSnippet(variableValuePattern);
            completionItems.add(this.getVariableCompletionItem(context, varSymbol, variableValueSnippet, varName));
        }
    }

    private String generateMatchSnippet(String patternClause) {
        return "{" + CommonUtil.LINE_SEPARATOR + patternClause + CommonUtil.LINE_SEPARATOR + "}";
    }
}

