/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;

public class ReturnStatementContextProvider
extends AbstractCompletionProvider {
    public ReturnStatementContextProvider() {
        this.attachmentPoints.add(BallerinaParser.ReturnStatementContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList visibleSymbols = new ArrayList((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        Integer invocationType = (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (invocationType > -1) {
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredItems = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(ctx);
            return this.getCompletionItemList(filteredItems, ctx);
        }
        List<Scope.ScopeEntry> filteredList = visibleSymbols.stream().filter(scopeEntry -> {
            BSymbol bSymbol = scopeEntry.symbol;
            return !(bSymbol instanceof BInvokableSymbol && ((BInvokableSymbol)bSymbol).receiverSymbol != null && CommonUtil.isValidInvokableSymbol(bSymbol) || bSymbol instanceof BTypeSymbol && !(bSymbol instanceof BPackageSymbol) || bSymbol instanceof BInvokableSymbol && (bSymbol.flags & 8) == 8);
        }).collect(Collectors.toList());
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_CHECK_PANIC.get()));
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_CHECK.get()));
        completionItems.addAll(this.getCompletionItemList(filteredList, ctx));
        completionItems.addAll(this.getPackagesCompletionItems(ctx));
        return completionItems;
    }
}

