/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.ballerinalang.langserver.SnippetBlock;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompletionSubRuleParser;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.AnnotationAccessExpressionContextProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.AnnotationAttachmentContextProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.InvocationArgsContextProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.InvocationOrFieldAccessContextProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.filters.StatementTemplateFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class StatementContextProvider
extends AbstractCompletionProvider {
    public StatementContextProvider() {
        this.attachmentPoints.add(StatementContextProvider.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext context) throws LSCompletionException {
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        Boolean inWorkerReturn = (Boolean)context.get(CompletionKeys.IN_WORKER_RETURN_CONTEXT_KEY);
        int invocationOrDelimiterTokenType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (this.isAnnotationAccessExpression(context)) {
            return this.getProvider(AnnotationAccessExpressionContextProvider.class).getCompletions(context);
        }
        if (this.isAnnotationAttachmentContext(context)) {
            return this.getProvider(AnnotationAttachmentContextProvider.class).getCompletions(context);
        }
        Optional<String> subRule = this.getSubRule(lhsTokens);
        subRule.ifPresent(rule -> CompletionSubRuleParser.parseWithinFunctionDefinition(rule, context));
        ParserRuleContext parserRuleContext = (ParserRuleContext)context.get(CompletionKeys.PARSER_RULE_CONTEXT_KEY);
        if (inWorkerReturn != null && inWorkerReturn.booleanValue()) {
            return this.getProvider(BallerinaParser.WorkerDeclarationContext.class).getCompletions(context);
        }
        if (parserRuleContext != null && this.getProvider(parserRuleContext.getClass()) != null) {
            return this.getProvider(parserRuleContext.getClass()).getCompletions(context);
        }
        if (this.inFunctionReturnParameterContext(context)) {
            return this.getProvider(BallerinaParser.ReturnParameterContext.class).getCompletions(context);
        }
        if (invocationOrDelimiterTokenType > -1) {
            return this.getProvider(InvocationOrFieldAccessContextProvider.class).getCompletions(context);
        }
        Boolean forceRemovedStmt = (Boolean)context.get(SourcePruneKeys.FORCE_REMOVED_STATEMENT_WITH_PARENTHESIS_KEY);
        ArrayList<Scope.ScopeEntry> filteredList = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        if (forceRemovedStmt != null && forceRemovedStmt.booleanValue()) {
            return this.getProvider(InvocationArgsContextProvider.class).getCompletions(context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getStaticCompletionItems(context));
        Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> itemList = SymbolFilters.get(StatementTemplateFilter.class).filterItems(context);
        completionItems.addAll(this.getCompletionItemList(itemList, context));
        completionItems.addAll(this.getTypeguardDestructedItems(filteredList, context));
        filteredList.removeIf(this.attachedSymbolFilter());
        completionItems.addAll(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(filteredList), context));
        completionItems.addAll(this.getPackagesCompletionItems(context));
        return completionItems;
    }

    private List<LSCompletionItem> getStaticCompletionItems(LSContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_NAMESPACE_DECLARATION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_WAIT.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_START.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FLUSH.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_ERROR.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_CHECK_PANIC.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_CHECK.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FINAL.get()));
        return completionItems;
    }

    private List<LSCompletionItem> getTypeguardDestructedItems(List<Scope.ScopeEntry> scopeEntries, LSContext ctx) {
        ArrayList capturedSymbols = new ArrayList();
        return scopeEntries.stream().filter(scopeEntry -> scopeEntry.symbol.type instanceof BUnionType && !capturedSymbols.contains(scopeEntry.symbol.name.value)).map(entry -> {
            capturedSymbols.add(entry.symbol.name.getValue());
            ArrayList errorTypes = new ArrayList();
            ArrayList resultTypes = new ArrayList();
            ArrayList members = new ArrayList(((BUnionType)entry.symbol.type).getMemberTypes());
            members.forEach(bType -> {
                if (bType.tag == 27) {
                    errorTypes.add(bType);
                } else {
                    resultTypes.add(bType);
                }
            });
            if (errorTypes.size() == 1) {
                resultTypes.addAll(errorTypes);
            }
            String symbolName = entry.symbol.name.getValue();
            String label = symbolName + " - typeguard " + symbolName;
            String detail = "Destructure the variable " + symbolName + " with typeguard";
            StringBuilder snippet = new StringBuilder();
            int paramCounter = 1;
            if (errorTypes.size() > 1) {
                snippet.append("if (").append(symbolName).append(" is ").append("error) {").append(CommonUtil.LINE_SEPARATOR).append("\t${1}").append(CommonUtil.LINE_SEPARATOR).append("}");
                ++paramCounter;
            } else if (errorTypes.size() == 1) {
                snippet.append("if (").append(symbolName).append(" is ").append(CommonUtil.getBTypeName((BType)errorTypes.get(0), ctx, true)).append(") {").append(CommonUtil.LINE_SEPARATOR).append("\t${1}").append(CommonUtil.LINE_SEPARATOR).append("}");
                ++paramCounter;
            }
            int finalParamCounter = paramCounter;
            String restSnippet = !snippet.toString().isEmpty() && resultTypes.size() > 2 ? " else " : "";
            restSnippet = restSnippet + IntStream.range(0, resultTypes.size() - paramCounter).mapToObj(value -> {
                BType bType = (BType)members.get(value);
                String placeHolder = "\t${" + (value + finalParamCounter) + "}";
                return "if (" + symbolName + " is " + CommonUtil.getBTypeName(bType, ctx, true) + ") {" + CommonUtil.LINE_SEPARATOR + placeHolder + CommonUtil.LINE_SEPARATOR + "}";
            }).collect(Collectors.joining(" else ")) + " else {" + CommonUtil.LINE_SEPARATOR + "\t${" + members.size() + "}" + CommonUtil.LINE_SEPARATOR + "}";
            snippet.append(restSnippet);
            SnippetBlock cItemSnippet = new SnippetBlock(label, snippet.toString(), detail, SnippetBlock.SnippetType.SNIPPET);
            return new SnippetCompletionItem(ctx, cItemSnippet);
        }).collect(Collectors.toList());
    }
}

