/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.SnippetBlock;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;

public class TypeDefinitionContextProvider
extends AbstractCompletionProvider {
    public TypeDefinitionContextProvider() {
        this.attachmentPoints.add(BallerinaParser.TypeDefinitionContext.class);
        this.attachmentPoints.add(BallerinaParser.FiniteTypeUnitContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        List lhsDefaultTokens = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        List lhsTokenTypes = lhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        if (this.isObjectTypeDefinition(ctx)) {
            return Arrays.asList(new SnippetCompletionItem(ctx, Snippet.KW_ABSTRACT.get()), new SnippetCompletionItem(ctx, Snippet.KW_CLIENT.get()));
        }
        if (lhsTokenTypes.contains(43)) {
            ArrayList<LSCompletionItem> lsCItems = new ArrayList<LSCompletionItem>();
            Integer invocationType = (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
            List visibleSymbols = (List)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY);
            if (invocationType == 96) {
                CommonToken pkgName = (CommonToken)lhsDefaultTokens.get(lhsTokenTypes.indexOf(invocationType) - 1);
                lsCItems.addAll(this.getTypeItemsInPackage(visibleSymbols, pkgName.getText(), ctx));
            } else if (lhsTokenTypes.contains(23) && lhsTokenTypes.contains(22)) {
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_OBJECT.get()));
            } else if (lhsTokenTypes.contains(23) || lhsTokenTypes.contains(22)) {
                SnippetBlock objectModifier = lhsTokenTypes.contains(23) ? Snippet.KW_ABSTRACT.get() : Snippet.KW_CLIENT.get();
                lsCItems.add(new SnippetCompletionItem(ctx, objectModifier));
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_OBJECT.get()));
            } else {
                lsCItems.addAll(this.getPackagesCompletionItems(ctx));
                lsCItems.addAll(this.getBasicTypesItems(ctx, visibleSymbols));
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_ABSTRACT.get()));
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_CLIENT.get()));
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_RECORD.get()));
                lsCItems.add(new SnippetCompletionItem(ctx, Snippet.KW_OBJECT.get()));
            }
            return lsCItems;
        }
        return new ArrayList<LSCompletionItem>();
    }

    private boolean isObjectTypeDefinition(LSContext ctx) {
        List rhsTokens = (List)ctx.get(SourcePruneKeys.RHS_TOKENS_KEY);
        List defaultRHSTokens = rhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        Optional<CommonToken> leftBrace = defaultRHSTokens.stream().filter(commonToken -> commonToken.getType() == 99).findFirst();
        if (!leftBrace.isPresent()) {
            return false;
        }
        int tokenBeforeBrace = ((CommonToken)defaultRHSTokens.get(defaultRHSTokens.indexOf(leftBrace.get()) - 1)).getType();
        return tokenBeforeBrace == 10;
    }
}

