/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.sourceprune;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.completions.sourceprune.LHSCompletionsTokenTraverser;
import org.ballerinalang.langserver.completions.sourceprune.RHSCompletionsTokenTraverser;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.TokenTraverser;
import org.ballerinalang.langserver.sourceprune.TokenTraverserFactory;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;

public class CompletionsTokenTraverserFactory
implements TokenTraverserFactory {
    private final SourcePruneContext sourcePruneCtx;
    private final boolean pruneTokens;
    private final TokenStream tokenStream;
    private static final List<Integer> BLOCK_REMOVE_KW_TERMINALS = Arrays.asList(7, 9, 43, 51, 53, 15);
    private static final List<Integer> LHS_TRAVERSE_TERMINALS = Arrays.asList(99, 100, 95, 98, 101, 102, 119, 19, 68, 107, 103);
    private static final List<Integer> RHS_TRAVERSE_TERMINALS = Arrays.asList(95, 164, 131, 99, 100, 102, 1, 118, 18, 7, 3, 4, 17, 9, 43, 12, 24, 104, 108, 8, 16, 51, 50, 54, 53, 56, 56, 57, 64, 68, 15, 11);

    public CompletionsTokenTraverserFactory(Path filePath, WorkspaceDocumentManager documentManager, SourcePruneContext sourcePruneCtx) throws WorkspaceDocumentException {
        this.sourcePruneCtx = sourcePruneCtx;
        String documentContent = documentManager.getFileContent(filePath);
        BallerinaParser parser = CommonUtil.prepareParser(documentContent);
        parser.compilationUnit();
        this.pruneTokens = parser.getNumberOfSyntaxErrors() > 0;
        this.tokenStream = parser.getTokenStream();
    }

    @Override
    public TokenTraverser createLHSTokenTraverser() {
        return new LHSCompletionsTokenTraverser(this.sourcePruneCtx, this.pruneTokens);
    }

    @Override
    public TokenTraverser createRHSTokenTraverser() {
        return new RHSCompletionsTokenTraverser(this.sourcePruneCtx, this.pruneTokens);
    }

    @Override
    public SourcePruneContext getSourcePruneCtx() {
        return this.sourcePruneCtx;
    }

    @Override
    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    @Override
    public List<Integer> getBlockRemoveTerminals() {
        return BLOCK_REMOVE_KW_TERMINALS;
    }

    @Override
    public List<Integer> getLHSTraverseTerminals() {
        return LHS_TRAVERSE_TERMINALS;
    }

    @Override
    public List<Integer> getRHSTraverseTerminals() {
        return RHS_TRAVERSE_TERMINALS;
    }
}

