/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.model.Whitespace;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CompletionVisitorUtil {
    private CompletionVisitorUtil() {
    }

    public static boolean isCursorWithinBlock(DiagnosticPos nodePosition, @Nonnull SymbolEnv symbolEnv, LSContext lsContext, TreeVisitor treeVisitor) {
        DiagnosticPos zeroBasedPosition = CommonUtil.toZeroBasedPosition(nodePosition);
        int line = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int nodeSLine = zeroBasedPosition.sLine;
        int nodeELine = zeroBasedPosition.eLine;
        if (nodeSLine <= line && nodeELine >= line) {
            HashMap<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = new HashMap<Name, List<Scope.ScopeEntry>>();
            if (symbolEnv.scope != null) {
                visibleSymbolEntries.putAll(treeVisitor.resolveAllVisibleSymbols(symbolEnv));
            }
            treeVisitor.populateSymbols(visibleSymbolEntries, symbolEnv);
            treeVisitor.forceTerminateVisitor();
            return true;
        }
        return false;
    }

    public static boolean cursorWithinServiceExpressionList(BLangService node, @Nonnull SymbolEnv symbolEnv, LSContext lsContext, TreeVisitor treeVisitor) {
        Position cursorPos = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        int line = cursorPos.getLine();
        int col = cursorPos.getCharacter();
        List attachedExprs = node.attachedExprs;
        if (attachedExprs.isEmpty()) {
            return false;
        }
        BLangExpression firstExpr = (BLangExpression)attachedExprs.get(0);
        BLangExpression lastExpr = (BLangExpression)CommonUtil.getLastItem(attachedExprs);
        DiagnosticPos firstExprPos = CommonUtil.toZeroBasedPosition(firstExpr.pos);
        int fSLine = firstExprPos.sLine;
        int fSCol = firstExprPos.sCol;
        DiagnosticPos lastExprPos = CommonUtil.toZeroBasedPosition(lastExpr.pos);
        int lSLine = lastExprPos.sLine;
        int lECol = lastExprPos.eCol;
        if (fSLine <= line && lSLine >= line && fSCol <= col && lECol >= col) {
            HashMap<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = new HashMap<Name, List<Scope.ScopeEntry>>();
            if (symbolEnv.scope != null) {
                visibleSymbolEntries.putAll(treeVisitor.resolveAllVisibleSymbols(symbolEnv));
            }
            treeVisitor.populateSymbols(visibleSymbolEntries, symbolEnv);
            treeVisitor.forceTerminateVisitor();
            return true;
        }
        return false;
    }

    public static boolean isWithinWorkerReturnContext(SymbolEnv env, LSContext lsContext, TreeVisitor treeVisitor, BLangFunction funcNode) {
        Position cursorPosition = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        DiagnosticPos position = CommonUtil.toZeroBasedPosition(funcNode.getPosition());
        ArrayList whitespaces = new ArrayList(funcNode.getWS());
        int cursorLine = cursorPosition.getLine();
        int cursorCol = cursorPosition.getCharacter();
        int sLine = position.sLine;
        int sCol = position.sCol;
        int openBraceStart = cursorCol;
        for (int counter = 1; counter <= whitespaces.size() - 1; ++counter) {
            Whitespace whitespace = (Whitespace)whitespaces.get(counter);
            if (whitespace.getPrevious().equals("{")) {
                openBraceStart += whitespace.getWs().length();
                break;
            }
            openBraceStart += whitespace.getPrevious().length() + whitespace.getWs().length();
        }
        if (cursorLine == sLine && cursorCol > sCol && cursorCol < openBraceStart) {
            lsContext.put(CompletionKeys.IN_WORKER_RETURN_CONTEXT_KEY, (Object)true);
            treeVisitor.populateSymbols(treeVisitor.resolveAllVisibleSymbols(env), env);
            treeVisitor.forceTerminateVisitor();
            return true;
        }
        return false;
    }

    public static boolean isWithinConditionContext(SymbolEnv env, LSContext lsContext, TreeVisitor treeVisitor, BLangNode conditionNode) {
        Position cursorPosition = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        BLangExpression expressionNode = null;
        if (conditionNode instanceof BLangIf) {
            expressionNode = ((BLangIf)conditionNode).expr;
        } else if (conditionNode instanceof BLangWhile) {
            expressionNode = ((BLangWhile)conditionNode).expr;
        }
        if (expressionNode == null) {
            return false;
        }
        DiagnosticPos exprPosition = CommonUtil.toZeroBasedPosition(expressionNode.pos);
        int cursorLine = cursorPosition.getLine();
        int cursorCol = cursorPosition.getCharacter();
        int sLine = exprPosition.sLine;
        int eLine = exprPosition.eLine;
        int sCol = exprPosition.sCol;
        int eCol = exprPosition.eCol;
        if (cursorLine > sLine && cursorLine < eLine || (cursorLine == sLine || cursorLine == eLine) && cursorCol >= sCol && cursorCol <= eCol) {
            lsContext.put(CompletionKeys.IN_CONDITION_CONTEXT_KEY, (Object)true);
            treeVisitor.populateSymbols(treeVisitor.resolveAllVisibleSymbols(env), env);
            treeVisitor.forceTerminateVisitor();
            return true;
        }
        return false;
    }

    public static List<BLangNode> getObjectItemsOrdered(BLangObjectTypeNode objectTypeNode) {
        ArrayList<BLangNode> nodes = new ArrayList<BLangNode>();
        if (objectTypeNode == null) {
            return nodes;
        }
        nodes.addAll(objectTypeNode.getFields().stream().map(field -> (BLangNode)field).collect(Collectors.toList()));
        nodes.addAll(objectTypeNode.getFunctions().stream().map(function -> function).collect(Collectors.toList()));
        if (objectTypeNode.initFunction != null) {
            nodes.add((BLangNode)objectTypeNode.initFunction);
        }
        nodes.sort(Comparator.comparing(node -> node.getPosition().getStartLine()));
        return nodes;
    }

    public static List<BLangNode> getFunctionParamsOrdered(BLangFunction function) {
        ArrayList<BLangNode> nodes = new ArrayList<BLangNode>();
        nodes.addAll(function.requiredParams);
        if (function.restParam != null) {
            nodes.add((BLangNode)function.restParam);
        }
        nodes.sort(Comparator.comparing(node -> node.getPosition().getStartLine()));
        return nodes;
    }

    public static boolean withinInvocationArguments(BLangNode node, LSContext lsContext) {
        Position position = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        int cursorLine = position.getLine();
        int cursorCol = position.getCharacter();
        if (!(node instanceof BLangExpressionStmt && ((BLangExpressionStmt)node).expr instanceof BLangInvocation || node instanceof BLangInvocation)) {
            return false;
        }
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(node.pos);
        int sLine = nodePos.sLine;
        int eLine = nodePos.eLine;
        int sCol = nodePos.sCol;
        int eCol = nodePos.eCol;
        if (cursorLine > sLine && cursorLine < eLine || cursorLine == sLine && sCol < cursorCol && eCol > cursorCol) {
            lsContext.put(CompletionKeys.IN_INVOCATION_PARAM_CONTEXT_KEY, (Object)true);
            return true;
        }
        return false;
    }

    public static boolean cursorBeforeInvocationNode(BLangNode node, LSContext context) {
        Position position = ((TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        int cursorLine = position.getLine();
        int cursorCol = position.getCharacter();
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(node.getPosition());
        int endLine = nodePos.eLine;
        int endCol = nodePos.eCol;
        return cursorLine < endLine || cursorLine == endLine && cursorCol < endCol;
    }
}

