/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.BlockStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ForkJoinStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.FunctionNodeScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.InvocationParameterScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.MatchExpressionScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.MatchStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ObjectTypeScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.PackageNodeScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.RecordLiteralScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.RecordScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ResourceParamScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ServiceScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.TopLevelNodeScopeResolver;

public enum CursorPositionResolvers {
    BLOCK_STMT_SCOPE(BlockStatementScopeResolver.class, new BlockStatementScopeResolver()),
    INVOCATION_SCOPE(InvocationParameterScopeResolver.class, new InvocationParameterScopeResolver()),
    PACKAGE_NODE_SCOPE(PackageNodeScopeResolver.class, new PackageNodeScopeResolver()),
    RESOURCE_PARAM_SCOPE(ResourceParamScopeResolver.class, new ResourceParamScopeResolver()),
    SERVICE_SCOPE(ServiceScopeResolver.class, new ServiceScopeResolver()),
    TOP_LEVEL_SCOPE(TopLevelNodeScopeResolver.class, new TopLevelNodeScopeResolver()),
    MATCH_NODE_SCOPE(MatchStatementScopeResolver.class, new MatchStatementScopeResolver()),
    MATCH_EXPR_NODE_SCOPE(MatchExpressionScopeResolver.class, new MatchExpressionScopeResolver()),
    RECORD_NODE_SCOPE(RecordScopeResolver.class, new RecordScopeResolver()),
    OBJECT_TYPE_SCOPE(ObjectTypeScopeResolver.class, new ObjectTypeScopeResolver()),
    RECORD_LITERAL_SCOPE(RecordLiteralScopeResolver.class, new RecordLiteralScopeResolver()),
    FORK_JOIN_SCOPE(ForkJoinStatementScopeResolver.class, new ForkJoinStatementScopeResolver()),
    FUNCTION_SCOPE_RESOLVER(FunctionNodeScopeResolver.class, new FunctionNodeScopeResolver());

    private final Class context;
    private final CursorPositionResolver cursorPositionResolver;
    private static final Map<Class, CursorPositionResolver> resolverMap;

    private CursorPositionResolvers(Class context, CursorPositionResolver positionResolver) {
        this.context = context;
        this.cursorPositionResolver = positionResolver;
    }

    private Class getContext() {
        return this.context;
    }

    private CursorPositionResolver getCompletionItemResolver() {
        return this.cursorPositionResolver;
    }

    public static CursorPositionResolver getResolverByClass(Class context) {
        return resolverMap.get(context);
    }

    private static Map<Class, CursorPositionResolver> initializeMapping() {
        HashMap<Class, CursorPositionResolver> map = new HashMap<Class, CursorPositionResolver>();
        for (CursorPositionResolvers resolver : CursorPositionResolvers.values()) {
            map.put(resolver.getContext(), resolver.getCompletionItemResolver());
        }
        return map;
    }

    static {
        resolverMap = Collections.unmodifiableMap(CursorPositionResolvers.initializeMapping());
    }
}

