/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.filters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.langserver.completions.util.filters.AbstractSymbolFilter;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.StatementTemplateFilter;

public enum SymbolFilters {
    ACTION_AND_FUNC_FILTER(DelimiterBasedContentFilter.class, new DelimiterBasedContentFilter()),
    STMT_TEMPLATE_FILTER(StatementTemplateFilter.class, new StatementTemplateFilter());

    private final Class context;
    private final AbstractSymbolFilter symbolFilter;
    private static final Map<Class, AbstractSymbolFilter> resolverMap;

    private SymbolFilters(Class context, AbstractSymbolFilter symbolFilter) {
        this.context = context;
        this.symbolFilter = symbolFilter;
    }

    private Class getContext() {
        return this.context;
    }

    private AbstractSymbolFilter getSymbolFilter() {
        return this.symbolFilter;
    }

    public static AbstractSymbolFilter get(Class context) {
        return resolverMap.get(context);
    }

    private static Map<Class, AbstractSymbolFilter> initializeMapping() {
        HashMap<Class, AbstractSymbolFilter> map = new HashMap<Class, AbstractSymbolFilter>();
        for (SymbolFilters resolver : SymbolFilters.values()) {
            map.put(resolver.getContext(), resolver.getSymbolFilter());
        }
        return map;
    }

    static {
        resolverMap = Collections.unmodifiableMap(SymbolFilters.initializeMapping());
    }
}

