/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.Node;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BlockStatementScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(nodePosition);
        int nodeSLine = zeroBasedPos.sLine;
        int nodeSCol = zeroBasedPos.sCol;
        int nodeELine = node instanceof BLangIf ? this.getIfElseNodeEndLine((BLangIf)node) : zeroBasedPos.eLine;
        int nodeECol = zeroBasedPos.eCol;
        BlockNode bLangBlockStmt = treeVisitor.getBlockStmtStack().peek();
        Node blockOwner = treeVisitor.getBlockOwnerStack().peek();
        boolean isLastStatement = this.isNodeLastStatement(bLangBlockStmt, blockOwner, (Node)node);
        boolean isWithinScopeAfterLastChild = this.isWithinScopeAfterLastChildNode(treeVisitor, isLastStatement, nodeELine, nodeECol, line, col);
        if (line < nodeSLine || line == nodeSLine && col <= nodeSCol || isWithinScopeAfterLastChild) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, treeVisitor.getSymbolEnv());
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
            return true;
        }
        return false;
    }

    private boolean isWithinScopeAfterLastChildNode(TreeVisitor treeVisitor, boolean lastChild, int nodeELine, int nodeECol, int line, int col) {
        if (!lastChild) {
            return false;
        }
        BlockNode blockNode = treeVisitor.getBlockStmtStack().peek();
        Node blockOwner = treeVisitor.getBlockOwnerStack().peek();
        int blockOwnerELine = this.getBlockOwnerELine(blockOwner, blockNode);
        int blockOwnerECol = this.getBlockOwnerECol(blockOwner, blockNode);
        return (line < blockOwnerELine || line == blockOwnerELine && col <= blockOwnerECol) && (line > nodeELine || line == nodeELine && col > nodeECol);
    }

    private boolean isNodeLastStatement(BlockNode blockNode, Node blockOwner, Node node) {
        Node parentNode = this.getParentNode(node);
        if (blockNode != null) {
            List statements = blockNode.getStatements().stream().filter(bLangStatement -> !CommonUtil.isWorkerDereivative(bLangStatement)).map(statementNode -> (BLangNode)statementNode).sorted(new CommonUtil.BLangNodeComparator()).collect(Collectors.toList());
            return statements.indexOf(parentNode) == statements.size() - 1;
        }
        if (blockOwner instanceof BLangTypeDefinition && ((BLangTypeDefinition)blockOwner).typeNode instanceof BLangObjectTypeNode) {
            List structFields = ((BLangObjectTypeNode)((BLangTypeDefinition)blockOwner).typeNode).getFields();
            return structFields.indexOf(parentNode) == structFields.size() - 1;
        }
        return false;
    }

    private Node getParentNode(Node node) {
        Node tempNode = node;
        while (tempNode != null && !(((BLangNode)tempNode).parent instanceof BLangBlockStmt) && !(((BLangNode)tempNode).parent instanceof BLangBlockFunctionBody)) {
            tempNode = ((BLangNode)tempNode).parent;
        }
        return tempNode;
    }

    private int getBlockOwnerELine(Node blockOwner, BlockNode blockNode) {
        if (blockOwner == null) {
            return CommonUtil.toZeroBasedPosition((DiagnosticPos)blockNode.getPosition()).getEndLine();
        }
        if (blockOwner instanceof BLangTransaction) {
            return this.getTransactionBlockComponentEndLine((BLangTransaction)blockOwner, blockNode);
        }
        return CommonUtil.toZeroBasedPosition((DiagnosticPos)blockOwner.getPosition()).getEndLine();
    }

    private int getBlockOwnerECol(Node blockOwner, BlockNode blockNode) {
        if (blockOwner == null) {
            return CommonUtil.toZeroBasedPosition((DiagnosticPos)blockNode.getPosition()).getEndColumn();
        }
        return CommonUtil.toZeroBasedPosition((DiagnosticPos)blockOwner.getPosition()).getEndColumn();
    }

    private int getTransactionBlockComponentEndLine(BLangTransaction bLangTransaction, BlockNode bLangBlockStmt) {
        BLangBlockStmt transactionBody = bLangTransaction.transactionBody;
        BLangBlockStmt failedBody = bLangTransaction.onRetryBody;
        ArrayList<BLangBlockStmt> components = new ArrayList<BLangBlockStmt>();
        components.add(transactionBody);
        components.add(failedBody);
        components.sort(Comparator.comparing(component -> {
            if (component != null) {
                return CommonUtil.toZeroBasedPosition(component.getPosition()).getEndLine();
            }
            return -1;
        }));
        int blockStmtIndex = components.indexOf(bLangBlockStmt);
        if (blockStmtIndex == components.size() - 1) {
            return CommonUtil.toZeroBasedPosition((DiagnosticPos)bLangTransaction.getPosition()).eLine;
        }
        if (components.get(blockStmtIndex + 1) != null) {
            return CommonUtil.toZeroBasedPosition((DiagnosticPos)((BLangBlockStmt)components.get((int)(blockStmtIndex + 1))).getPosition()).sLine;
        }
        return -1;
    }

    private int getIfElseNodeEndLine(BLangIf bLangIf) {
        BLangIf ifNode = bLangIf;
        while (true) {
            if (ifNode.elseStmt == null) {
                return CommonUtil.toZeroBasedPosition((DiagnosticPos)ifNode.getPosition()).eLine;
            }
            if (!(ifNode.elseStmt instanceof BLangIf)) break;
            ifNode = (BLangIf)ifNode.elseStmt;
        }
        return CommonUtil.toZeroBasedPosition(ifNode.elseStmt.getPosition()).getEndLine();
    }
}

