/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class FunctionNodeScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        boolean isWithinScopeAfterLastChild;
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        BLangInvokableNode bLangInvokableNode = (BLangInvokableNode)treeVisitor.getBlockOwnerStack().peek();
        DiagnosticPos invokeableNodePos = CommonUtil.toZeroBasedPosition(bLangInvokableNode.getPosition());
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(nodePosition);
        int nodeSLine = zeroBasedPos.sLine;
        int nodeSCol = zeroBasedPos.sCol;
        int nodeELine = zeroBasedPos.eLine;
        int invokeableNodeEndLine = invokeableNodePos.getEndLine();
        boolean isLastWorker = bLangInvokableNode.getWorkers().indexOf(node) == bLangInvokableNode.getWorkers().size() - 1;
        boolean bl = isWithinScopeAfterLastChild = isLastWorker && line > nodeELine && line < invokeableNodeEndLine;
        if (line < nodeSLine || line == nodeSLine && col <= nodeSCol || isWithinScopeAfterLastChild) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, treeVisitor.getSymbolEnv());
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
            return true;
        }
        return false;
    }
}

