/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class MatchStatementScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        if (!(treeVisitor.getBlockOwnerStack().peek() instanceof BLangMatch)) {
            return false;
        }
        BLangMatch matchNode = (BLangMatch)treeVisitor.getBlockOwnerStack().peek();
        DiagnosticPos matchNodePos = CommonUtil.toZeroBasedPosition(matchNode.getPosition());
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(node.getPosition());
        List patternClauseList = matchNode.patternClauses;
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        int nodeStartLine = nodePos.getStartLine();
        int nodeEndLine = nodePos.getEndLine();
        int nodeCol = nodePos.getStartColumn();
        boolean isBeforeNode = false;
        if (line < nodeStartLine || line == nodeStartLine && col < nodeCol || matchNodePos.getStartLine() <= line && matchNodePos.getEndLine() >= line && patternClauseList.indexOf(node) == patternClauseList.size() - 1 && nodeEndLine < line) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            SymbolEnv matchEnv = MatchStatementScopeResolver.createMatchEnv(matchNode, treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, matchEnv);
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
            isBeforeNode = true;
        }
        return isBeforeNode;
    }

    private static SymbolEnv createMatchEnv(BLangMatch match, SymbolEnv env) {
        SymbolEnv symbolEnv = new SymbolEnv((BLangNode)match, null);
        env.copyTo(symbolEnv);
        return symbolEnv;
    }
}

