/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class RecordScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        boolean isCursorBefore;
        Node recordNode = treeVisitor.getBlockOwnerStack().peek();
        if (!recordNode.getKind().equals((Object)NodeKind.RECORD_TYPE)) {
            return false;
        }
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(node.getPosition());
        DiagnosticPos ownerPos = CommonUtil.toZeroBasedPosition(((BLangRecordTypeNode)recordNode).parent.getPosition());
        int ownerEndLine = ownerPos.getEndLine();
        int nodeStartLine = nodePos.getStartLine();
        int nodeEndLine = nodePos.getEndLine();
        int nodeStartCol = nodePos.getStartColumn();
        BLangRecordTypeNode bLangRecord = (BLangRecordTypeNode)recordNode;
        List fields = bLangRecord.fields;
        boolean isLastField = fields.indexOf(node) == fields.size() - 1;
        boolean bl = isCursorBefore = nodeStartLine > line || nodeStartLine == line && nodeStartCol > col || isLastField && this.isCursorWithinScopeAfterLastChild(line, ownerEndLine, nodeEndLine);
        if (isCursorBefore) {
            treeVisitor.forceTerminateVisitor();
            SymbolEnv recordEnv = RecordScopeResolver.createRecordEnv((BLangRecordTypeNode)recordNode, treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(treeVisitor.resolveAllVisibleSymbols(recordEnv), recordEnv);
        }
        return isCursorBefore;
    }

    private static SymbolEnv createRecordEnv(BLangRecordTypeNode record, SymbolEnv env) {
        SymbolEnv symbolEnv = new SymbolEnv((BLangNode)record, env.scope);
        env.copyTo(symbolEnv);
        return symbolEnv;
    }

    private boolean isCursorWithinScopeAfterLastChild(int cLine, int ownerELine, int nodeELine) {
        return cLine > nodeELine && cLine < ownerELine;
    }
}

