/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.sorters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.langserver.completions.util.sorters.CompletionItemSorter;
import org.ballerinalang.langserver.completions.util.sorters.DefaultItemSorter;
import org.ballerinalang.langserver.completions.util.sorters.context.DefinitionContext;
import org.ballerinalang.langserver.completions.util.sorters.context.ImportDeclarationContext;
import org.ballerinalang.langserver.completions.util.sorters.scope.PackageScope;
import org.ballerinalang.langserver.completions.util.sorters.scope.ServiceScope;

public enum ItemSorters {
    DEFAULT_ITEM_SORTER(new DefaultItemSorter()),
    SERVICE_SCOPE_ITEM_SORTER(new ServiceScope()),
    DEFINITION_CTX_ITEM_SORTER(new DefinitionContext()),
    PACKAGE_SCOPE_ITEM_SORTER(new PackageScope()),
    IMPORT_DECL_CTX_ITEM_SORTER(new ImportDeclarationContext());

    private final CompletionItemSorter itemSorter;
    private static final Map<Class, CompletionItemSorter> resolverMap;

    private ItemSorters(CompletionItemSorter itemSorter) {
        this.itemSorter = itemSorter;
    }

    private CompletionItemSorter getItemSorter() {
        return this.itemSorter;
    }

    public static CompletionItemSorter get(Class context) {
        if (context == null || !resolverMap.containsKey(context)) {
            return resolverMap.get(DefaultItemSorter.class);
        }
        return resolverMap.get(context);
    }

    private static Map<Class, CompletionItemSorter> initializeMapping() {
        HashMap<Class, CompletionItemSorter> map = new HashMap<Class, CompletionItemSorter>();
        for (ItemSorters resolver : ItemSorters.values()) {
            for (Class attachedContext : resolver.itemSorter.getAttachedContexts()) {
                map.put(attachedContext, resolver.getItemSorter());
            }
        }
        return map;
    }

    static {
        resolverMap = Collections.unmodifiableMap(ItemSorters.initializeMapping());
    }
}

