/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.example;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleCategory;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleListRequest;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleListResponse;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleService;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class BallerinaExampleServiceImpl
implements BallerinaExampleService {
    private static final String BBE_DEF_JSON = "index.json";
    private static final String EXAMPLES_DIR = "examples";
    private static final Type EXAMPLE_CATEGORY_TYPE = new TypeToken<List<BallerinaExampleCategory>>(){}.getType();

    @Override
    public CompletableFuture<BallerinaExampleListResponse> list(BallerinaExampleListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaExampleListResponse response = new BallerinaExampleListResponse();
            Gson gson = new Gson();
            Path bbeJSONPath = Paths.get(CommonUtil.BALLERINA_HOME, new String[0]).resolve(EXAMPLES_DIR).resolve(BBE_DEF_JSON);
            try {
                InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(bbeJSONPath.toFile()), StandardCharsets.UTF_8);
                JsonReader jsonReader = new JsonReader((Reader)fileReader);
                List data = (List)gson.fromJson(jsonReader, EXAMPLE_CATEGORY_TYPE);
                response.setSamples(data);
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaExample/list' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)new TextDocumentIdentifier(bbeJSONPath.toString()), (Position[])new Position[]{null});
                response.setSamples(new ArrayList<BallerinaExampleCategory>());
            }
            return response;
        });
    }
}

