/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.fragment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.format.JSONGenerationException;
import org.ballerinalang.langserver.compiler.format.TextDocumentFormatUtil;
import org.ballerinalang.langserver.compiler.sourcegen.FormattingSourceGen;
import org.ballerinalang.langserver.extensions.ballerina.fragment.BallerinaFragmentASTRequest;
import org.ballerinalang.langserver.extensions.ballerina.fragment.BallerinaFragmentASTResponse;
import org.ballerinalang.langserver.extensions.ballerina.fragment.BallerinaFragmentService;
import org.ballerinalang.model.tree.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;

public class BallerinaFragmentServiceImpl
implements BallerinaFragmentService {
    private static final Logger logger = LoggerFactory.getLogger(BallerinaFragmentServiceImpl.class);
    private static final String SYNTAX_ERRORS = "syntax_errors";
    private static final String ERROR = "error";

    @Override
    public CompletableFuture<BallerinaFragmentASTResponse> ast(BallerinaFragmentASTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (CommonUtil.isCachedExternalSource(request.getSource())) {
                return null;
            }
            BallerinaFragmentASTResponse response = new BallerinaFragmentASTResponse();
            response.setAst(BallerinaFragmentServiceImpl.parseFragment(request));
            return response;
        });
    }

    private static JsonObject parseFragment(BallerinaFragmentASTRequest sourceFragment) {
        try {
            String parsableString = BallerinaFragmentServiceImpl.getParsableString(sourceFragment);
            JsonElement jsonElement = BallerinaFragmentServiceImpl.getJsonModel(parsableString);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonModel = (JsonObject)jsonElement;
                if (jsonModel.getAsJsonArray(SYNTAX_ERRORS) != null) {
                    return jsonModel;
                }
                JsonObject jsonASTFragment = BallerinaFragmentServiceImpl.getJsonNodeForFragment(jsonModel, sourceFragment);
                return FormattingSourceGen.build((JsonObject)jsonASTFragment, null);
            }
        }
        catch (CompilationFailedException | JSONGenerationException e) {
            logger.error("Error while generating AST for fragment", e);
        }
        return null;
    }

    private static JsonObject getJsonNodeForFragment(JsonObject jsonModel, BallerinaFragmentASTRequest fragment) {
        JsonObject fragmentNode;
        JsonArray jsonArray = jsonModel.getAsJsonArray("topLevelNodes");
        JsonObject rootConstruct = jsonArray.get(0).getAsJsonObject();
        switch (fragment.getExpectedNodeType()) {
            case "top-level-node": {
                fragmentNode = rootConstruct;
                break;
            }
            case "service-resource": {
                fragmentNode = rootConstruct.getAsJsonArray("resources").get(0).getAsJsonObject();
                break;
            }
            case "connector-action": {
                fragmentNode = rootConstruct.getAsJsonArray("actions").get(0).getAsJsonObject();
                break;
            }
            case "worker": {
                fragmentNode = rootConstruct.getAsJsonArray("workers").get(0).getAsJsonObject();
                break;
            }
            case "variable_reference_list": {
                JsonObject assignmentStmt = rootConstruct.getAsJsonArray("children").get(2).getAsJsonObject();
                fragmentNode = assignmentStmt.getAsJsonArray("children").get(0).getAsJsonObject();
                break;
            }
            case "field_definition_list": {
                fragmentNode = rootConstruct.getAsJsonObject("typeNode").getAsJsonArray("fields").get(0).getAsJsonObject();
                break;
            }
            case "anon_Record": {
                fragmentNode = jsonModel;
                break;
            }
            case "transaction_failed": 
            case "expression": 
            case "statement": {
                fragmentNode = rootConstruct.getAsJsonObject("body").getAsJsonArray("statements").get(0).getAsJsonObject();
                break;
            }
            case "endpoint_var_def": {
                fragmentNode = rootConstruct.getAsJsonArray("endpointNodes").get(0).getAsJsonObject();
                break;
            }
            case "join-condition": {
                JsonObject bodyJsonObj = rootConstruct.getAsJsonObject("body");
                fragmentNode = bodyJsonObj.getAsJsonArray("statements").get(0).getAsJsonObject();
                break;
            }
            case "argument_parameter_definitions": {
                fragmentNode = rootConstruct.getAsJsonArray("parameters").get(0).getAsJsonObject();
                break;
            }
            case "return_parameter_definitions": {
                fragmentNode = rootConstruct.getAsJsonArray("returnParameters").get(0).getAsJsonObject();
                break;
            }
            default: {
                fragmentNode = new JsonObject();
                fragmentNode.addProperty(ERROR, "cannot find node for given fragment");
            }
        }
        return fragmentNode;
    }

    private static JsonElement getJsonModel(String source) throws CompilationFailedException, JSONGenerationException {
        BallerinaFile model = ExtendedLSCompiler.compileContent((String)source, (CompilerPhase)CompilerPhase.DEFINE);
        Optional<BLangCompilationUnit> compilationUnit = model.getBLangPackage().map(b -> b.getCompilationUnits().stream().filter(compUnit -> "untitled.bal".equals(compUnit.getName())).findFirst().orElse(null));
        return TextDocumentFormatUtil.generateJSON((Node)compilationUnit.orElse(null), new HashMap(), new HashMap());
    }

    private static String getParsableString(BallerinaFragmentASTRequest sourceFragment) {
        String parsableText = null;
        String source = sourceFragment.getSource();
        switch (sourceFragment.getExpectedNodeType()) {
            case "top-level-node": {
                parsableText = source;
                break;
            }
            case "service-resource": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("service<http:Service> name bind ep{\n$FRAGMENT\n}", source);
                break;
            }
            case "connector-action": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("connector ClientConnector(string ag){\n$FRAGMENT\n}", source);
                break;
            }
            case "expression": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction(){any val =\n$FRAGMENT;\n}", source);
                break;
            }
            case "worker": 
            case "endpoint_var_def": 
            case "statement": 
            case "anon_Record": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction(){\n$FRAGMENT\n}", source);
                break;
            }
            case "join-condition": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction(){\nfork{\n} join($FRAGMENT)(map param){\n}\n}", source);
                break;
            }
            case "argument_parameter_definitions": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction($FRAGMENT){\n}", source);
                break;
            }
            case "return_parameter_definitions": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction()($FRAGMENT){\n}", source);
                break;
            }
            case "transaction_failed": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction(){\ntransaction{\n}failed{\n$FRAGMENT\n}aborted{\n}committed{\n}\n}", source);
                break;
            }
            case "variable_reference_list": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("function testFunction(){\n$FRAGMENT=testFunction();\n}", source);
                break;
            }
            case "field_definition_list": {
                parsableText = BallerinaFragmentServiceImpl.getFromTemplate("type record1 record {\n$FRAGMENT\n};", source);
                break;
            }
            default: {
                parsableText = "";
            }
        }
        return parsableText;
    }

    private static String getFromTemplate(String template, String source) {
        return template.replace("$FRAGMENT", source);
    }
}

