/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.semantichighlighter;

import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.HighlightingFailedException;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.ScopeEnum;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingInformation;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingKeys;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingParams;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingToken;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class SemanticHighlightProvider {
    public static void sendHighlights(ExtendedLanguageClient client, LSContext context, WorkspaceDocumentManager docManager) throws CompilationFailedException, HighlightingFailedException {
        if (client != null) {
            client.publishTextHighlighting(SemanticHighlightProvider.getHighlights(context, docManager));
        }
    }

    public static SemanticHighlightingParams getHighlights(LSContext context, WorkspaceDocumentManager docManager) throws CompilationFailedException, HighlightingFailedException {
        LSModuleCompiler.getBLangPackages((LSContext)context, (WorkspaceDocumentManager)docManager, null, (boolean)true, (boolean)true, (boolean)true);
        ArrayList highlights = new ArrayList();
        context.put(SemanticHighlightingKeys.SEMANTIC_HIGHLIGHTING_KEY, highlights);
        SemanticHighlightingVisitor semanticHighlightingVisitor = new SemanticHighlightingVisitor(context);
        BLangPackage bLangPackage = (BLangPackage)context.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        if (bLangPackage != null) {
            bLangPackage.accept((BLangNodeVisitor)semanticHighlightingVisitor);
        }
        if (context.get(SemanticHighlightingKeys.SEMANTIC_HIGHLIGHTING_KEY) == null) {
            throw new HighlightingFailedException("Couldn't find any highlight information!");
        }
        HashMap<Integer, int[]> lineInfo = new HashMap<Integer, int[]>();
        ArrayList<SemanticHighlightingInformation> highlightsArr = new ArrayList<SemanticHighlightingInformation>();
        ((List)context.get(SemanticHighlightingKeys.SEMANTIC_HIGHLIGHTING_KEY)).forEach(element -> {
            int line = element.identifier.pos.sLine - 1;
            int[] token = SemanticHighlightProvider.getToken(element);
            if (lineInfo.get(line) != null) {
                int[] cur = (int[])lineInfo.get(line);
                lineInfo.put(line, Ints.concat((int[][])new int[][]{cur, token}));
            } else {
                lineInfo.put(line, token);
            }
        });
        for (Map.Entry mapElement : lineInfo.entrySet()) {
            highlightsArr.add(SemanticHighlightProvider.getEncodedToken(mapElement, lineInfo));
        }
        return new SemanticHighlightingParams((String)context.get(DocumentServiceKeys.FILE_URI_KEY), highlightsArr);
    }

    private static int[] getToken(HighlightInfo element) {
        int character = element.identifier.pos.sCol - 1;
        int length = element.identifier.pos.eCol - element.identifier.pos.sCol;
        int scope = element.scopeEnum.getScopeId();
        SemanticHighlightingToken highlightingToken = new SemanticHighlightingToken(character, length, scope);
        int[] token = new int[]{highlightingToken.getCharacter(), highlightingToken.getLength(), highlightingToken.getScope()};
        return token;
    }

    private static SemanticHighlightingInformation getEncodedToken(Map.Entry mapElement, Map<Integer, int[]> lineInfo) {
        Integer key = (Integer)mapElement.getKey();
        String tokenArr = Arrays.toString(lineInfo.get(key));
        String encodedToken = Base64.getEncoder().encodeToString(tokenArr.getBytes(StandardCharsets.UTF_8));
        SemanticHighlightingInformation highlightingInformation = new SemanticHighlightingInformation(key, encodedToken);
        return highlightingInformation;
    }

    public static class HighlightInfo {
        ScopeEnum scopeEnum;
        BLangIdentifier identifier;

        public HighlightInfo(ScopeEnum scopeEnum, BLangIdentifier identifier) {
            this.scopeEnum = scopeEnum;
            this.identifier = identifier;
        }
    }
}

