/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.traces;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.langserver.extensions.ballerina.traces.Message;

public class LogParser {
    static final Pattern ID_PATTERN = Pattern.compile("id: ([a-z0-9]*)");
    static final Pattern DIRECTION = Pattern.compile("(INBOUND|OUTBOUND)");
    static final Pattern HEADER = Pattern.compile("(?:INBOUND|OUTBOUND): (.*[\\n\\r])([\\s\\S]*)");
    static final Pattern HTTP_METHOD = Pattern.compile("(GET|POST|HEAD|POST|PUT|DELETE|CONNECT|OPTIONS|TRACE|PATCH)");
    static final Pattern PATH = Pattern.compile("(?:GET|POST|HEAD|POST|PUT|DELETE|CONNECT|OPTIONS|TRACE|PATCH) ([^\\s]+)");
    static final Pattern CONTENT_TYPE = Pattern.compile("(?:content-type): ?(.*)", 2);
    static final Pattern PAYLOAD_REQUEST = Pattern.compile("(?:DefaultLastHttpContent)(?:.*[\\n\\r])([\\s\\S]*)");
    static final Pattern PAYLOAD_RESPONSE = Pattern.compile("(?:DefaultFullHttpResponse)(?:.*[\\n\\r])(?:[\\s\\S]*)(?:[\\n\\r])([\\s\\S]*)");

    private static String getId(String logLine) {
        Matcher matcher = ID_PATTERN.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getDirection(String logLine) {
        Matcher matcher = DIRECTION.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getHeaderType(String logLine) {
        Matcher matcher = HEADER.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getHeader(String logLine) {
        Matcher matcher = HEADER.matcher(logLine);
        return matcher.find() ? matcher.group(2) : "";
    }

    private static String getHttpMethod(String logLine) {
        Matcher matcher = HTTP_METHOD.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getPath(String logLine) {
        Matcher matcher = PATH.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getContentType(String logLine) {
        Matcher matcher = CONTENT_TYPE.matcher(logLine);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String getPayload(String logLine) {
        String payload = "";
        Matcher requestMatcher = PAYLOAD_REQUEST.matcher(logLine);
        Matcher responseMatcher = PAYLOAD_RESPONSE.matcher(logLine);
        if (requestMatcher.find()) {
            payload = requestMatcher.group(1);
        }
        if (responseMatcher.find()) {
            payload = responseMatcher.group(1);
        }
        return payload;
    }

    private static String removePayload(String header, String payload) {
        return header.substring(0, header.length() - payload.length());
    }

    static Message fromString(String logLine) {
        String id = LogParser.getId(logLine);
        String direction = LogParser.getDirection(logLine);
        String header = LogParser.getHeader(logLine);
        String headerType = LogParser.getHeaderType(logLine);
        String payload = LogParser.getPayload(logLine);
        String headers = LogParser.removePayload(header, payload);
        String httpMethod = LogParser.getHttpMethod(logLine);
        String path = LogParser.getPath(logLine);
        String contentType = LogParser.getContentType(logLine);
        return new Message(id, direction, headers, httpMethod, path, contentType, payload, headerType);
    }
}

