/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.hover.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.symbols.SymbolKind;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;

public class HoverUtil {
    public static Hover getHoverFromDocAttachment(MarkdownDocAttachment docAttachment, BSymbol symbol, LSContext ctx) {
        String docAttributes;
        MarkupContent hoverMarkupContent = new MarkupContent();
        if (docAttachment == null) {
            Hover hover = new Hover();
            ArrayList<Either> contents = new ArrayList<Either>();
            contents.add(Either.forLeft((Object)""));
            hover.setContents(contents);
            return hover;
        }
        hoverMarkupContent.setKind("markdown");
        StringBuilder content = new StringBuilder();
        Map<String, List<MarkdownDocAttachment.Parameter>> filterAttributes = HoverUtil.filterDocumentationAttributes(docAttachment, symbol);
        if (docAttachment.description != null && !docAttachment.description.isEmpty()) {
            String description = CommonUtil.MD_LINE_SEPARATOR + docAttachment.description.trim() + CommonUtil.MD_LINE_SEPARATOR;
            content.append(HoverUtil.getFormattedHoverDocContent("Description", description));
        }
        if (filterAttributes.get("PARAM") != null && !(docAttributes = HoverUtil.getDocAttributes(filterAttributes.get("PARAM"), symbol, ctx)).isEmpty()) {
            content.append(HoverUtil.getFormattedHoverDocContent("Params", docAttributes));
        }
        if (filterAttributes.get("FIELD") != null && !(docAttributes = HoverUtil.getDocAttributes(filterAttributes.get("FIELD"), symbol, ctx)).isEmpty()) {
            content.append(HoverUtil.getFormattedHoverDocContent("Field", docAttributes));
        }
        if (docAttachment.returnValueDescription != null && !docAttachment.returnValueDescription.isEmpty()) {
            String returnType = "";
            if (symbol instanceof BInvokableSymbol) {
                BInvokableSymbol invokableSymbol = (BInvokableSymbol)symbol;
                returnType = " `" + CommonUtil.getBTypeName(invokableSymbol.retType, ctx, false) + "`";
            }
            content.append(HoverUtil.getFormattedHoverDocContent("Returns", returnType, HoverUtil.getReturnValueDescription(docAttachment.returnValueDescription)));
        }
        hoverMarkupContent.setValue(content.toString());
        return new Hover(hoverMarkupContent);
    }

    public static Hover getDefaultHoverObject() {
        Hover hover = new Hover();
        MarkupContent hoverMarkupContent = new MarkupContent();
        hoverMarkupContent.setKind("markdown");
        hoverMarkupContent.setValue("");
        hover.setContents(hoverMarkupContent);
        return hover;
    }

    public static MarkdownDocAttachment getMarkdownDocForSymbol(BSymbol bSymbol) {
        SymbolKind symbolKind;
        SymbolKind symbolKind2 = symbolKind = bSymbol.kind == null ? bSymbol.type.tsymbol.kind : bSymbol.kind;
        if (symbolKind == null) {
            return bSymbol.markdownDocumentation;
        }
        MarkdownDocAttachment markdownDocAttachment = null;
        switch (symbolKind) {
            case RECORD: 
            case OBJECT: {
                markdownDocAttachment = bSymbol.type.tsymbol.markdownDocumentation;
                break;
            }
            case ANNOTATION: {
                markdownDocAttachment = ((BAnnotationSymbol)bSymbol.type.tsymbol).attachedType.markdownDocumentation;
                break;
            }
            case FUNCTION: {
                markdownDocAttachment = bSymbol.markdownDocumentation;
                break;
            }
        }
        return markdownDocAttachment;
    }

    private static Map<String, List<MarkdownDocAttachment.Parameter>> filterDocumentationAttributes(MarkdownDocAttachment docAttachment, BSymbol symbol) {
        SymbolKind symbolKind;
        HashMap<String, List<MarkdownDocAttachment.Parameter>> filteredAttributes = new HashMap<String, List<MarkdownDocAttachment.Parameter>>();
        String paramType = "";
        SymbolKind symbolKind2 = symbolKind = symbol.kind == null ? symbol.type.tsymbol.kind : symbol.kind;
        if (symbolKind == null) {
            return filteredAttributes;
        }
        switch (symbolKind) {
            case FUNCTION: {
                paramType = "PARAM";
                break;
            }
            case RECORD: 
            case OBJECT: 
            case ANNOTATION: 
            case TYPE_DEF: {
                paramType = "FIELD";
                break;
            }
        }
        for (MarkdownDocAttachment.Parameter parameter : docAttachment.parameters) {
            if (filteredAttributes.get(paramType) == null) {
                filteredAttributes.put(paramType, new ArrayList());
                ((List)filteredAttributes.get(paramType)).add(parameter);
                continue;
            }
            ((List)filteredAttributes.get(paramType)).add(parameter);
        }
        return filteredAttributes;
    }

    private static String getDocAttributes(List<MarkdownDocAttachment.Parameter> parameters, BSymbol symbol, LSContext ctx) {
        HashMap<String, BVarSymbol> paramSymbols = new HashMap<String, BVarSymbol>();
        if (symbol instanceof BVarSymbol && !(symbol instanceof BInvokableSymbol)) {
            symbol = ((BVarSymbol)symbol).type.tsymbol;
        }
        boolean skipFirstParam = false;
        if (symbol instanceof BInvokableSymbol) {
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)symbol;
            List params = invokableSymbol.params;
            int invocationType = ctx == null || ctx.get(NodeContextKeys.INVOCATION_TOKEN_TYPE_KEY) == null ? -1 : (Integer)ctx.get(NodeContextKeys.INVOCATION_TOKEN_TYPE_KEY);
            skipFirstParam = CommonUtil.skipFirstParam(invokableSymbol, invocationType);
            for (int i = 0; i < params.size(); ++i) {
                if (i == 0 && skipFirstParam) continue;
                BVarSymbol param = (BVarSymbol)params.get(i);
                paramSymbols.put(param.name.value, param);
            }
        } else if (symbol instanceof BStructureTypeSymbol || symbol instanceof BAnnotationSymbol) {
            Map entries;
            if (symbol instanceof BStructureTypeSymbol) {
                BStructureTypeSymbol objectTypeSymbol = (BStructureTypeSymbol)symbol;
                entries = objectTypeSymbol.scope.entries;
            } else {
                entries = ((BAnnotationSymbol)symbol).attachedType.scope.entries;
            }
            entries.values().stream().filter(s -> s.symbol instanceof BVarSymbol && s.symbol.getFlags().contains(Flag.PUBLIC)).forEach(s -> paramSymbols.put(s.symbol.name.value, (BVarSymbol)s.symbol));
        }
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == 0 && skipFirstParam) continue;
            MarkdownDocAttachment.Parameter parameter = parameters.get(i);
            boolean isOptional = false;
            String type = "";
            if (!paramSymbols.isEmpty() && paramSymbols.get(parameter.name) != null) {
                isOptional = (((BSymbol)paramSymbols.get((Object)parameter.name)).flags & 0x2000) == 8192;
                type = "`" + CommonUtil.getBTypeName(((BSymbol)paramSymbols.get((Object)parameter.name)).type, ctx, false) + "` ";
            }
            value.append("- ").append(type).append("**").append(parameter.name.trim()).append(isOptional ? "?" : "").append("**").append(": ").append(parameter.description.trim()).append(CommonUtil.MD_LINE_SEPARATOR);
        }
        return value.toString();
    }

    private static String getReturnValueDescription(String returnVal) {
        return "- " + CommonUtil.MD_NEW_LINE_PATTERN.matcher(returnVal).replaceAll(CommonUtil.MD_LINE_SEPARATOR) + CommonUtil.MD_LINE_SEPARATOR;
    }

    private static String getFormattedHoverDocContent(String header, String content) {
        return HoverUtil.getFormattedHoverDocContent(header, "", content);
    }

    private static String getFormattedHoverDocContent(String header, String subHeader, String content) {
        return "**" + header + "**" + subHeader + CommonUtil.MD_LINE_SEPARATOR + CommonUtil.MD_NEW_LINE_PATTERN.matcher(content).replaceAll(CommonUtil.MD_LINE_SEPARATOR) + CommonUtil.MD_LINE_SEPARATOR;
    }
}

