/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.implementation;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Token;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.implementation.GotoImplementationKeys;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class GotoImplementationCustomErrorStrategy
extends LSCustomErrorStrategy {
    private LSContext lsContext;
    private int line;
    private int col;
    private boolean terminateCheck = false;
    private String relativeSourceFilePath;

    public GotoImplementationCustomErrorStrategy(LSContext context) {
        super(context);
        this.lsContext = context;
        Position position = ((TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        this.line = position.getLine();
        this.col = position.getCharacter();
        this.relativeSourceFilePath = ((String)this.lsContext.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY)).replace("\\", "/");
    }

    public void reportMatch(Parser recognizer) {
        super.reportMatch(recognizer);
        if (recognizer.getSourceName().equals(this.relativeSourceFilePath) && !this.terminateCheck) {
            Token currentToken = recognizer.getCurrentToken();
            int tokenLine = currentToken.getLine() - 1;
            int tokenStartCol = currentToken.getCharPositionInLine();
            int tokenStopCol = tokenStartCol + currentToken.getText().length();
            if (this.line == tokenLine && this.col >= tokenStartCol && this.col <= tokenStopCol) {
                this.lsContext.put(GotoImplementationKeys.SYMBOL_TOKEN_KEY, (Object)currentToken.getText());
                this.terminateCheck = true;
            }
        }
    }
}

