/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.implementation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.implementation.GotoImplementationKeys;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class GotoImplementationUtil {
    private GotoImplementationUtil() {
    }

    public static List<Location> getImplementationLocation(BLangPackage bLangPkg, LSContext ctx, Position position, String srcRoot) {
        int line = position.getLine();
        ArrayList<Location> implementationLocations = new ArrayList<Location>();
        String packageName = bLangPkg.packageID.name.toString();
        String funcName = (String)ctx.get(GotoImplementationKeys.SYMBOL_TOKEN_KEY);
        boolean isTestSrc = CommonUtil.isTestSource((String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY));
        Object evalPkg = isTestSrc ? bLangPkg.getTestablePkg() : bLangPkg;
        List<TopLevelNode> topLevelNodes = CommonUtil.getCurrentFileTopLevelNodes(evalPkg, ctx);
        Optional<BLangObjectTypeNode> bLangObjectTypeNode = GotoImplementationUtil.getObjectTypeNode(topLevelNodes, line);
        if (!bLangObjectTypeNode.isPresent()) {
            return implementationLocations;
        }
        Optional<BLangFunction> interfaceFunction = GotoImplementationUtil.getInterfaceFunction(bLangObjectTypeNode.get(), funcName);
        if (!interfaceFunction.isPresent()) {
            return implementationLocations;
        }
        evalPkg.topLevelNodes.stream().filter(node -> node instanceof BLangFunction && ((BLangFunction)node).flagSet.contains(Flag.ATTACHED) && ((BLangFunction)node).symbol == ((BLangFunction)interfaceFunction.get()).symbol).map(node -> (BLangFunction)node).forEach(function -> implementationLocations.add(GotoImplementationUtil.getLocation(srcRoot, packageName, function)));
        return implementationLocations;
    }

    private static Location getLocation(String sourceRoot, String pkgName, BLangFunction bLangFunction) {
        String cUnitName = bLangFunction.getPosition().src.cUnitName;
        Location location = new Location();
        DiagnosticPos implPosition = CommonUtil.toZeroBasedPosition(bLangFunction.getPosition());
        Range range = new Range(new Position(implPosition.sLine, implPosition.sCol), new Position(implPosition.eLine, implPosition.eCol));
        location.setRange(range);
        String uri = new File(sourceRoot).toPath().resolve(pkgName).resolve(cUnitName).toUri().toString();
        location.setUri(uri);
        return location;
    }

    private static Optional<BLangFunction> getInterfaceFunction(BLangObjectTypeNode node, String functionName) {
        return node.functions.stream().filter(bLangFunction -> bLangFunction.flagSet.contains(Flag.INTERFACE) && bLangFunction.symbol.getName().getValue() != null && bLangFunction.symbol.getName().getValue().endsWith("." + functionName)).findAny();
    }

    private static Optional<BLangObjectTypeNode> getObjectTypeNode(List<TopLevelNode> topLevelNodes, int line) {
        return topLevelNodes.stream().filter(node -> {
            DiagnosticPos nodePosition = (DiagnosticPos)node.getPosition();
            DiagnosticPos zeroBasedPosition = CommonUtil.toZeroBasedPosition(nodePosition);
            return NodeKind.TYPE_DEFINITION.equals((Object)node.getKind()) && NodeKind.OBJECT_TYPE.equals((Object)((BLangTypeDefinition)node).typeNode.getKind()) && zeroBasedPosition.sLine <= line && zeroBasedPosition.eLine >= line;
        }).map(topLevelNode -> (BLangObjectTypeNode)((BLangTypeDefinition)topLevelNode).typeNode).findAny();
    }
}

