/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature.sourceprune;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.sourceprune.AbstractTokenTraverser;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;

class LHSSignatureTokenTraverser
extends AbstractTokenTraverser {
    private List<Integer> lhsTraverseTerminals;
    private SourcePruneContext sourcePruneContext;
    private boolean forcedProcessedToken = false;
    private boolean capturedFirstLeftParenthesis = false;
    private boolean capturedFirstColon = false;
    private int pendingRightParenthesis = 1;
    private int pendingLeftParenthesis = 1;
    private int pendingLeftBrace = 0;
    private int pendingLeftBracket = 0;
    private boolean isCommaTerminal = true;
    private boolean isCapturingEnabled = true;
    private boolean captureStatement = false;
    private boolean addSemiColon = false;

    LHSSignatureTokenTraverser(SourcePruneContext sourcePruneContext, boolean pruneTokens) {
        super(pruneTokens);
        this.sourcePruneContext = sourcePruneContext;
        this.lhsTraverseTerminals = sourcePruneContext.get(SourcePruneKeys.LHS_TRAVERSE_TERMINALS_KEY);
        this.processedTokens = new ArrayList();
    }

    @Override
    public List<CommonToken> traverse(TokenStream tokenStream, int tokenIndex) {
        int type;
        Optional<Object> token = Optional.of(tokenStream.get(tokenIndex));
        if (token.isPresent() && (type = token.get().getType()) == 98) {
            this.isCommaTerminal = false;
        }
        while (token.isPresent()) {
            boolean terminate;
            type = token.get().getType();
            if (token.get().getChannel() != 0 && this.capturedFirstLeftParenthesis) {
                boolean explicitInit;
                Optional<Token> prevToken = CommonUtil.getPreviousDefaultToken(tokenStream, tokenIndex);
                boolean bl = explicitInit = prevToken.isPresent() && prevToken.get().getType() == 48;
                if (!this.captureStatement && this.processedTokens.size() >= 2) {
                    CommonToken nToken = (CommonToken)this.processedTokens.get(this.processedTokens.size() - 1);
                    CommonToken nnToken = (CommonToken)this.processedTokens.get(this.processedTokens.size() - 2);
                    boolean bl2 = this.captureStatement = nToken.getType() == 48 && nnToken.getType() == 101;
                }
                if (!explicitInit && !this.captureStatement && this.pendingLeftParenthesis == 0) {
                    this.isCapturingEnabled = false;
                }
            }
            if (this.lhsTraverseTerminals.contains(type) && (terminate = this.terminateLHSTraverse(token.get(), tokenStream))) break;
            boolean bl = this.addSemiColon = this.addSemiColon || token.get().getType() == 51;
            if (!this.forcedProcessedToken) {
                this.processToken(token.get());
            }
            this.forcedProcessedToken = false;
            tokenIndex = token.get().getTokenIndex() - 1;
            token = tokenIndex < 0 ? Optional.empty() : Optional.of(tokenStream.get(tokenIndex));
        }
        this.sourcePruneContext.put(SourcePruneKeys.LEFT_PARAN_COUNT_KEY, this.pendingLeftParenthesis);
        this.sourcePruneContext.put(SourcePruneKeys.RIGHT_PARAN_COUNT_KEY, this.pendingRightParenthesis);
        this.sourcePruneContext.put(SourcePruneKeys.LEFT_BRACE_COUNT_KEY, this.pendingLeftBrace);
        this.sourcePruneContext.put(SourcePruneKeys.ADD_SEMICOLON_COUNT_KEY, this.addSemiColon);
        Collections.reverse(this.processedTokens);
        this.removeProceedingNonDefaultTokens(this.processedTokens);
        return this.processedTokens;
    }

    private void removeProceedingNonDefaultTokens(List<CommonToken> processedTokens) {
        CommonToken token;
        int len = processedTokens.size();
        for (int i = 0; i < len && (token = processedTokens.get(i)).getChannel() != 0; --len, ++i) {
            processedTokens.remove(token);
            --i;
        }
    }

    private boolean terminateLHSTraverse(Token token, TokenStream tokenStream) {
        int type = token.getType();
        String text = token.getText();
        if (type == 102) {
            boolean isFieldAccess;
            boolean bl = isFieldAccess = this.lastProcessedToken.getType() == 97 || this.lastProcessedToken.getType() == 106;
            if (isFieldAccess) {
                this.isCommaTerminal = false;
            }
            if (this.capturedFirstLeftParenthesis && !isFieldAccess) {
                return true;
            }
            ++this.pendingLeftParenthesis;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 101) {
            Optional<Token> tokenToLeft = CommonUtil.getPreviousDefaultToken(tokenStream, token.getTokenIndex());
            if (this.pendingLeftParenthesis > 0) {
                --this.pendingLeftParenthesis;
                this.isCommaTerminal = true;
                this.capturedFirstLeftParenthesis = true;
                return false;
            }
            this.isCommaTerminal = true;
            if (this.capturedFirstLeftParenthesis) {
                return true;
            }
            this.capturedFirstLeftParenthesis = true;
            if (tokenToLeft.isPresent() && (50 == tokenToLeft.get().getType() || 54 == tokenToLeft.get().getType())) {
                this.replaceCondition(tokenStream, token.getTokenIndex());
            }
            this.isCommaTerminal = true;
            this.capturedFirstLeftParenthesis = true;
            return false;
        }
        if (type == 100) {
            ++this.pendingLeftBrace;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 99) {
            if (this.pendingLeftBrace > 0) {
                --this.pendingLeftBrace;
                return false;
            }
            return true;
        }
        if (type == 206 && "${".equals(text)) {
            ++this.pendingLeftBrace;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 104) {
            ++this.pendingLeftBracket;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 103) {
            if (this.pendingLeftBracket > 0) {
                --this.pendingLeftBracket;
                return false;
            }
            return true;
        }
        if (type == 98) {
            if (this.isCommaTerminal && this.capturedFirstLeftParenthesis) {
                this.processToken(token);
                this.forcedProcessedToken = true;
                return true;
            }
            return false;
        }
        if (type == 109) {
            if (this.capturedFirstLeftParenthesis) {
                return true;
            }
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 95) {
            this.forcedProcessedToken = true;
            return true;
        }
        if (type == 134) {
            this.forcedProcessedToken = true;
            return true;
        }
        if (type == 96) {
            if (this.capturedFirstColon) {
                this.forcedProcessedToken = true;
                return true;
            }
            this.capturedFirstColon = true;
        }
        return this.pendingLeftParenthesis == 0 && this.pendingRightParenthesis == 0;
    }

    @Override
    protected boolean processToken(Token token) {
        if (this.isCapturingEnabled) {
            return super.processToken(token);
        }
        if (token.getType() == 170 || token.getType() == -1 || token.getChannel() != 0 || token.getType() == 169) {
            return false;
        }
        this.lastProcessedToken = token;
        if (this.pruneTokens) {
            ((CommonToken)token).setText(LHSSignatureTokenTraverser.getNCharLengthEmptyLine(token.getText().length()));
            ((CommonToken)token).setType(169);
            return true;
        }
        return false;
    }
}

