/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature.sourceprune;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.sourceprune.AbstractTokenTraverser;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;

class RHSSignatureTokenTraverser
extends AbstractTokenTraverser {
    private final List<Integer> rhsTraverseTerminals;
    private final boolean addSemiColon;
    private int pendingRightParenthesis;
    private int pendingLeftBrace;
    private boolean forcedProcessedToken;
    private boolean capturedLastRightParenthesis;

    RHSSignatureTokenTraverser(SourcePruneContext sourcePruneContext, boolean pruneTokens) {
        super(pruneTokens);
        this.pendingRightParenthesis = sourcePruneContext.get(SourcePruneKeys.RIGHT_PARAN_COUNT_KEY);
        this.rhsTraverseTerminals = sourcePruneContext.get(SourcePruneKeys.RHS_TRAVERSE_TERMINALS_KEY);
        this.pendingLeftBrace = sourcePruneContext.get(SourcePruneKeys.LEFT_BRACE_COUNT_KEY);
        this.addSemiColon = sourcePruneContext.get(SourcePruneKeys.ADD_SEMICOLON_COUNT_KEY);
        this.forcedProcessedToken = false;
        this.capturedLastRightParenthesis = false;
        this.processedTokens = new ArrayList();
    }

    @Override
    public List<CommonToken> traverse(TokenStream tokenStream, int tokenIndex) {
        boolean terminateRHSTraverse;
        int type;
        Optional<Object> token = Optional.of(tokenStream.get(tokenIndex));
        while (!(!token.isPresent() || this.rhsTraverseTerminals.contains(type = token.get().getType()) && (terminateRHSTraverse = this.terminateRHSTraverse(token.get())) || type == 170 && this.capturedLastRightParenthesis)) {
            if (!this.forcedProcessedToken) {
                this.processToken(token.get());
            }
            this.forcedProcessedToken = false;
            tokenIndex = token.get().getTokenIndex() + 1;
            token = tokenIndex > tokenStream.size() - 1 ? Optional.empty() : Optional.of(tokenStream.get(tokenIndex));
        }
        if (token.isPresent() && this.addSemiColon) {
            this.checkForSemiColon(tokenStream, tokenIndex, token.get());
        }
        return this.processedTokens;
    }

    private boolean terminateRHSTraverse(Token token) {
        int type = token.getType();
        if (type == 102) {
            boolean result;
            if (this.pendingRightParenthesis > 0) {
                --this.pendingRightParenthesis;
                result = false;
            } else {
                if (!this.capturedLastRightParenthesis) {
                    this.processToken(token);
                }
                result = true;
            }
            if (this.pendingRightParenthesis == 0) {
                this.capturedLastRightParenthesis = true;
            }
            return result;
        }
        if (type == 100 && this.pendingLeftBrace > 0) {
            --this.pendingLeftBrace;
            return false;
        }
        return type != 131 || this.lastProcessedToken.getType() != 102;
    }

    private void checkForSemiColon(TokenStream tokenStream, int tokenIndex, Token token) {
        boolean isWS;
        if (token == null || this.lastProcessedToken == null) {
            return;
        }
        while (token.getChannel() != 0) {
            if (++tokenIndex < 0) {
                return;
            }
            token = tokenStream.get(tokenIndex);
        }
        boolean bl = isWS = this.lastProcessedToken.getType() == 169;
        if (token.getType() != 95 && isWS) {
            CommonToken lastProcessedToken = (CommonToken)this.lastProcessedToken;
            lastProcessedToken.setText(";");
            lastProcessedToken.setType(95);
            lastProcessedToken.setChannel(0);
        }
    }
}

