/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.sourceprune;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.sourceprune.TokenTraverser;

public abstract class AbstractTokenTraverser
implements TokenTraverser {
    protected Token lastProcessedToken = null;
    protected boolean pruneTokens;
    protected List<CommonToken> processedTokens = new ArrayList<CommonToken>();

    public AbstractTokenTraverser(boolean pruneTokens) {
        this.pruneTokens = pruneTokens;
    }

    protected boolean processToken(Token token) {
        this.processedTokens.add(new CommonToken(token));
        if (token.getType() == 170 || token.getType() == -1 || token.getChannel() != 0 || token.getType() == 169) {
            return false;
        }
        this.lastProcessedToken = new CommonToken(token);
        if (this.pruneTokens) {
            ((CommonToken)token).setText(AbstractTokenTraverser.getNCharLengthEmptyLine(token.getText().length()));
            ((CommonToken)token).setType(169);
            return true;
        }
        return false;
    }

    protected static String getNCharLengthEmptyLine(int n) {
        return String.join((CharSequence)"", Collections.nCopies(n, " "));
    }

    protected void replaceCondition(TokenStream tokenStream, int tokenIndex) {
        Optional<Token> nextDefaultToken = CommonUtil.getNextDefaultToken(tokenStream, tokenIndex);
        nextDefaultToken.ifPresent(token -> ((CommonToken)token).setText(String.join((CharSequence)"_", Collections.nCopies(token.getText().length() / 2, "a"))));
    }
}

