/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.sourceprune;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.exceptions.CompletionContextNotSupportedException;
import org.ballerinalang.langserver.completions.util.SourcePruneException;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.langserver.sourceprune.TokenTraverserFactory;
import org.ballerinalang.langserver.util.TokensUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class SourcePruner {
    public static void pruneSource(LSContext lsContext, TokenTraverserFactory traverserFactory) throws SourcePruneException {
        TokenStream tokenStream = traverserFactory.getTokenStream();
        Position cursorPosition = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        if (cursorPosition == null) {
            throw new SourcePruneException("Cursor position cannot be null!");
        }
        ArrayList<Token> tokenList = new ArrayList<Token>(((CommonTokenStream)tokenStream).getTokens());
        Optional<Token> tokenAtCursor = TokensUtil.searchTokenAtCursor(lsContext, tokenList, cursorPosition.getLine(), cursorPosition.getCharacter(), false, false);
        if (tokenAtCursor.isPresent() && (tokenAtCursor.get().getText().startsWith("//") || tokenAtCursor.get().getText().startsWith("#"))) {
            throw new CompletionContextNotSupportedException("Operations within Comments are not Supported");
        }
        tokenAtCursor.ifPresent(token -> lsContext.put(SourcePruneKeys.CURSOR_TOKEN_INDEX_KEY, (Object)tokenList.indexOf(token)));
        lsContext.put(SourcePruneKeys.TOKEN_LIST_KEY, tokenList);
        int tokenIndex = tokenAtCursor.map(Token::getTokenIndex).orElse(-1);
        if (tokenIndex < 0 || tokenIndex >= tokenStream.size()) {
            return;
        }
        SourcePruneContext sourcePruneCtx = traverserFactory.getSourcePruneCtx();
        sourcePruneCtx.put(SourcePruneKeys.LHS_TRAVERSE_TERMINALS_KEY, traverserFactory.getLHSTraverseTerminals());
        sourcePruneCtx.put(SourcePruneKeys.RHS_TRAVERSE_TERMINALS_KEY, traverserFactory.getRHSTraverseTerminals());
        sourcePruneCtx.put(SourcePruneKeys.BLOCK_REMOVE_KW_TERMINALS_KEY, traverserFactory.getBlockRemoveTerminals());
        List<CommonToken> lhsTokens = traverserFactory.createLHSTokenTraverser().traverse(tokenStream, tokenIndex);
        List<CommonToken> rhsTokens = traverserFactory.createRHSTokenTraverser().traverse(tokenStream, tokenIndex + 1);
        List lhsDefaultTokens = lhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        List rhsDefaultTokens = rhsTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        List lhsDefaultTokenTypes = lhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        List rhsDefaultTokenTypes = rhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        lsContext.put(SourcePruneKeys.LHS_TOKENS_KEY, lhsTokens);
        lsContext.put(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY, lhsDefaultTokens);
        lsContext.put(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY, lhsDefaultTokenTypes);
        lsContext.put(SourcePruneKeys.RHS_TOKENS_KEY, rhsTokens);
        lsContext.put(SourcePruneKeys.RHS_DEFAULT_TOKENS_KEY, rhsDefaultTokens);
        lsContext.put(SourcePruneKeys.RHS_DEFAULT_TOKEN_TYPES_KEY, rhsDefaultTokenTypes);
        lsContext.put(SourcePruneKeys.FORCE_REMOVED_STATEMENT_WITH_PARENTHESIS_KEY, (Object)sourcePruneCtx.get(SourcePruneKeys.FORCE_CAPTURED_STATEMENT_WITH_PARENTHESIS_KEY));
    }

    public static SourcePruneContext newContext() {
        SourcePruneContext context = new SourcePruneContext(LSContextOperation.SOURCE_PRUNER);
        context.put(SourcePruneKeys.GT_COUNT_KEY, 0);
        context.put(SourcePruneKeys.LT_COUNT_KEY, 0);
        context.put(SourcePruneKeys.LEFT_BRACE_COUNT_KEY, 0);
        context.put(SourcePruneKeys.RIGHT_BRACE_COUNT_KEY, 0);
        context.put(SourcePruneKeys.LEFT_PARAN_COUNT_KEY, 0);
        context.put(SourcePruneKeys.RIGHT_PARAN_COUNT_KEY, 0);
        context.put(SourcePruneKeys.LEFT_BRACKET_COUNT_KEY, 0);
        context.put(SourcePruneKeys.RIGHT_BRACKET_COUNT_KEY, 0);
        return context;
    }
}

