/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util;

import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class TokensUtil {
    private TokensUtil() {
    }

    public static void searchTokenAtCursor(String content, LSContext context, Position pos) {
        List<Token> tokenList = CommonUtil.getTokenList(content);
        Boolean nextBest = (Boolean)context.get(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST);
        Optional<Token> tokenAtCursor = TokensUtil.searchTokenAtCursor(context, tokenList, pos.getLine(), pos.getCharacter(), true, nextBest == null ? false : nextBest);
        tokenAtCursor.ifPresent(token -> {
            context.put(NodeContextKeys.NODE_NAME_KEY, (Object)token.getText());
            int tokenIndex = token.getTokenIndex() - 1;
            int tokenType = -1;
            if (tokenIndex > 0) {
                tokenType = ((Token)tokenList.get(tokenIndex)).getType();
            }
            context.put(NodeContextKeys.INVOCATION_TOKEN_TYPE_KEY, (Object)tokenType);
        });
    }

    public static Optional<Token> searchTokenAtCursor(LSContext context, List<Token> tokenList, int cLine, int cCol, boolean identifiersOnly, boolean offsetAndTryNextBest) {
        return TokensUtil.searchTokenAtCursor(context, tokenList, 0, tokenList.size(), cLine, cCol, identifiersOnly, offsetAndTryNextBest);
    }

    private static Optional<Token> searchTokenAtCursor(LSContext context, List<Token> tokenList, int start, int end, int cLine, int cCol, boolean identifiersOnly, boolean offsetAndTryNextBest) {
        if (tokenList.isEmpty()) {
            return Optional.empty();
        }
        if (start < 0 || end > tokenList.size()) {
            return Optional.empty();
        }
        int tokenIndex = start + (end - start) / 2;
        if (tokenIndex == end) {
            return Optional.empty();
        }
        TokenPosition position = TokensUtil.locateTokenAtCursor(tokenList.get(tokenIndex), cLine, cCol, identifiersOnly, offsetAndTryNextBest);
        switch (position) {
            case THIS_TOKEN: {
                return Optional.ofNullable(tokenList.get(tokenIndex));
            }
            case NEXT_TOKEN: {
                if (!offsetAndTryNextBest) {
                    return Optional.empty();
                }
                Token nextToken = tokenList.get(tokenIndex);
                Boolean findLiteralsObj = (Boolean)context.get(ReferencesKeys.ENABLE_FIND_LITERALS);
                boolean findLiterals = findLiteralsObj != null ? findLiteralsObj : false;
                boolean isValid = TokensUtil.isValidToken(nextToken, findLiterals);
                while (nextToken != null && !isValid) {
                    Token token = nextToken = tokenList.size() > ++tokenIndex ? tokenList.get(tokenIndex) : null;
                    if (nextToken != null && nextToken.getLine() - 1 != cLine) {
                        nextToken = null;
                    }
                    isValid = TokensUtil.isValidToken(nextToken, findLiterals);
                }
                if (nextToken != null) {
                    TextDocumentPositionParams positionParams = (TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY);
                    positionParams.setPosition(new Position(nextToken.getLine() - 1, nextToken.getCharPositionInLine()));
                    context.put(DocumentServiceKeys.POSITION_KEY, (Object)positionParams);
                }
                return Optional.ofNullable(nextToken);
            }
            case LEFT_SIDE: {
                return TokensUtil.searchTokenAtCursor(context, tokenList, start, tokenIndex, cLine, cCol, identifiersOnly, offsetAndTryNextBest);
            }
        }
        return TokensUtil.searchTokenAtCursor(context, tokenList, tokenIndex + 1, end, cLine, cCol, identifiersOnly, offsetAndTryNextBest);
    }

    private static boolean isValidToken(Token nextToken, boolean findLiterals) {
        if (nextToken == null) {
            return false;
        }
        boolean defaultChannel = nextToken.getChannel() == 0;
        boolean isARecordStart = nextToken.getType() == 99;
        boolean isACastStart = nextToken.getType() == 119;
        boolean isAnArrayStart = nextToken.getType() == 103;
        boolean isAFunction = nextToken.getType() == 9;
        boolean isAFromClause = nextToken.getType() == 88;
        boolean isALiteral = nextToken.getType() == 151 || nextToken.getType() == 152 || nextToken.getType() == 153 || nextToken.getType() == 154 || nextToken.getType() == 155 || nextToken.getType() == 156 || nextToken.getType() == 157 || nextToken.getType() == 158 || nextToken.getType() == 159 || nextToken.getType() == 160 || nextToken.getType() == 162 || nextToken.getType() == 163;
        return defaultChannel && (findLiterals && (isAFromClause || isACastStart || isARecordStart || isAnArrayStart || isAFunction || isALiteral) || nextToken.getType() == 161);
    }

    private static TokenPosition locateTokenAtCursor(Token token, int cLine, int cCol, boolean identifiersOnly, boolean tryNextBest) {
        int tokenLine = token.getLine() - 1;
        int tokenStartCol = token.getCharPositionInLine();
        int tokenEndCol = tokenStartCol + (token.getText().equals("\r\n") || token.getText().equals("\n") ? 0 : token.getText().length());
        if (identifiersOnly) {
            return TokensUtil.locateIdentifierTokenAtCursor(token, cLine, cCol, tokenLine, tokenStartCol, tokenEndCol, tryNextBest);
        }
        if (tokenLine == cLine && tokenStartCol < cCol && tokenEndCol >= cCol && token.getType() != 170) {
            return TokenPosition.THIS_TOKEN;
        }
        if (cLine > tokenLine || tokenLine == cLine && cCol > tokenEndCol) {
            return TokenPosition.RIGHT_SIDE;
        }
        return TokenPosition.LEFT_SIDE;
    }

    private static TokenPosition locateIdentifierTokenAtCursor(Token token, int cLine, int cCol, int tokenLine, int tokenStartCol, int tokenEndCol, boolean tryNextBest) {
        boolean isValid;
        boolean bl = isValid = token.getType() == 161 || "new".equals(token.getText());
        if (tokenLine == cLine && tokenStartCol <= cCol && tokenEndCol >= cCol) {
            return isValid ? TokenPosition.THIS_TOKEN : (tryNextBest ? TokenPosition.NEXT_TOKEN : TokenPosition.LEFT_SIDE);
        }
        if (cLine > tokenLine || tokenLine == cLine && cCol >= tokenEndCol) {
            return TokenPosition.RIGHT_SIDE;
        }
        return TokenPosition.LEFT_SIDE;
    }

    private static enum TokenPosition {
        THIS_TOKEN,
        NEXT_TOKEN,
        LEFT_SIDE,
        RIGHT_SIDE;

    }
}

