/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.definition;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.exception.LSStdlibCacheException;
import org.ballerinalang.langserver.util.definition.LSStdLibCacheUtil;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class LSStandardLibCache {
    private static final LSStandardLibCache STANDARD_LIB_CACHE = new LSStandardLibCache();
    private volatile boolean cacheUpdating = false;
    private boolean cacheProjectRootSuccess;
    private LoadingCache<String, List<TopLevelNode>> topLevelNodeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<TopLevelNode>>(){

        public List<TopLevelNode> load(@Nonnull String module) throws UnsupportedEncodingException, LSStdlibCacheException {
            LSStdLibCacheUtil.extractSourceForCacheableKey(module);
            return LSStandardLibCache.this.getNodesForModule(module);
        }
    });

    private LSStandardLibCache() {
        try {
            Files.createDirectories(CommonUtil.LS_STDLIB_CACHE_DIR, new FileAttribute[0]);
            this.cacheProjectRootSuccess = true;
            this.populateLangLibs();
        }
        catch (IOException e) {
            this.cacheProjectRootSuccess = false;
        }
    }

    public static LSStandardLibCache getInstance() {
        return STANDARD_LIB_CACHE;
    }

    public void updateCache(List<BLangImportPackage> importPackages) throws LSStdlibCacheException {
        if (!this.cacheProjectRootSuccess) {
            throw new LSStdlibCacheException("Trying to access failed cache");
        }
        if (this.cacheUpdating || importPackages == null || importPackages.isEmpty()) {
            return;
        }
        Set cachedModules = this.topLevelNodeCache.asMap().keySet();
        List evalModules = importPackages.parallelStream().filter(importModule -> !cachedModules.contains(LSStdLibCacheUtil.getCacheableKey(importModule))).collect(Collectors.toList());
        new Thread(() -> {
            try {
                this.cacheUpdating = true;
                evalModules.forEach(module -> {
                    String orgName = module.getOrgName().getValue();
                    String moduleName = LSStdLibCacheUtil.getCacheableKey(module);
                    try {
                        LSStdLibCacheUtil.extractSourceForImportModule(orgName, module);
                        this.topLevelNodeCache.put((Object)moduleName, this.getNodesForModule(moduleName));
                    }
                    catch (IOException | LSStdlibCacheException exception) {
                        // empty catch block
                    }
                });
            }
            finally {
                this.cacheUpdating = false;
            }
        }).start();
    }

    public List<TopLevelNode> getTopLevelNodesForModule(LSContext context, PackageID pkgId) {
        Boolean enabled = (Boolean)context.get(DocumentServiceKeys.ENABLE_STDLIB_DEFINITION_KEY);
        if (enabled == null || !enabled.booleanValue()) {
            return new ArrayList<TopLevelNode>();
        }
        String cachedModuleName = LSStdLibCacheUtil.getCacheableKey(pkgId);
        return (List)this.topLevelNodeCache.getUnchecked((Object)cachedModuleName);
    }

    public Path getCachedStdlibRoot(String pkgName) throws LSStdlibCacheException {
        if (!this.cacheProjectRootSuccess) {
            throw new LSStdlibCacheException("Cache Root could not initialized");
        }
        return CommonUtil.LS_STDLIB_CACHE_DIR.resolve(pkgName);
    }

    private void populateLangLibs() {
        List<String> langLibs = Arrays.asList("array", "decimal", "error", "float", "future", "int", "map", "object", "stream", "string", "table", "typedesc", "value", "xml");
        if (this.cacheUpdating) {
            return;
        }
        new Thread(() -> {
            try {
                for (String langLib : langLibs) {
                    String cacheableKey = "ballerina_lang." + langLib + "_0.0.0";
                    LSStdLibCacheUtil.extractSourceForCacheableKey(cacheableKey);
                    this.topLevelNodeCache.put((Object)cacheableKey, this.getNodesForModule(cacheableKey));
                }
            }
            catch (UnsupportedEncodingException | LSStdlibCacheException exception) {
            }
            finally {
                this.cacheUpdating = false;
            }
        }).start();
    }

    private List<TopLevelNode> getNodesForModule(String moduleName) throws UnsupportedEncodingException {
        Compiler compiler = this.getCompiler(CommonUtil.LS_STDLIB_CACHE_DIR.resolve(moduleName).toString());
        BLangPackage bLangPackage = compiler.compile(moduleName);
        return bLangPackage.topLevelNodes.stream().filter(topLevelNode -> {
            BLangIdentifier nodeName;
            switch (topLevelNode.getKind()) {
                case FUNCTION: {
                    nodeName = ((BLangFunction)topLevelNode).name;
                    break;
                }
                case TYPE_DEFINITION: {
                    nodeName = ((BLangTypeDefinition)topLevelNode).name;
                    break;
                }
                case CONSTANT: {
                    nodeName = ((BLangConstant)topLevelNode).name;
                    break;
                }
                case ANNOTATION: {
                    nodeName = ((BLangAnnotation)topLevelNode).name;
                    break;
                }
                default: {
                    nodeName = null;
                }
            }
            return nodeName != null && !nodeName.getValue().contains("$");
        }).collect(Collectors.toList());
    }

    private CompilerContext createNewCompilerContext(String projectDir) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, projectDir);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.DESUGAR.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.toString(false));
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(true));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(true));
        context.put(SourceDirectory.class, (Object)new FileSystemProjectDirectory(Paths.get(projectDir, new String[0])));
        context.put(DiagnosticListener.class, (Object)new CollectDiagnosticListener());
        return context;
    }

    private Compiler getCompiler(String projectDir) throws UnsupportedEncodingException {
        Compiler compiler = Compiler.getInstance((CompilerContext)this.createNewCompilerContext(projectDir));
        compiler.setOutStream((PrintStream)new LSCompilerUtil.EmptyPrintStream());
        return compiler;
    }
}

