/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.references;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.hover.util.HoverUtil;
import org.ballerinalang.langserver.util.TokensUtil;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.SymbolReferenceFindingVisitor;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ReferencesUtil {
    private ReferencesUtil() {
    }

    public static SymbolReferencesModel.Reference getReferenceAtCursor(LSContext context, LSDocumentIdentifier document, Position position) throws WorkspaceDocumentException, CompilationFailedException {
        TextDocumentIdentifier textDocIdentifier = new TextDocumentIdentifier(document.getURIString());
        TextDocumentPositionParams pos = new TextDocumentPositionParams(textDocIdentifier, position);
        context.put(DocumentServiceKeys.POSITION_KEY, (Object)pos);
        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)document.getURIString());
        context.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)true);
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, false);
        ReferencesUtil.findReferences(modules, context);
        context.put(DocumentServiceKeys.BLANG_PACKAGES_CONTEXT_KEY, modules);
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = referencesModel.getReferenceAtCursor();
        return symbolAtCursor.orElse(null);
    }

    public static WorkspaceEdit getRenameWorkspaceEdits(LSContext context, String newName) throws WorkspaceDocumentException, CompilationFailedException {
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, false);
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        String nodeName = (String)context.get(NodeContextKeys.NODE_NAME_KEY);
        if ("new".equals(nodeName)) {
            throw new IllegalStateException("Symbol at cursor '" + nodeName + "' not supported or could not find!");
        }
        ReferencesUtil.findReferences(modules, context);
        ReferencesUtil.fillAllReferences(modules, context);
        return ReferencesUtil.getWorkspaceEdit(referencesModel, context, newName);
    }

    public static List<Location> getReferences(LSContext context, boolean includeDeclaration) throws WorkspaceDocumentException, CompilationFailedException {
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, false);
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        ReferencesUtil.findReferences(modules, context);
        ReferencesUtil.fillAllReferences(modules, context);
        ArrayList<SymbolReferencesModel.Reference> references = new ArrayList<SymbolReferencesModel.Reference>();
        if (includeDeclaration) {
            references.addAll(referencesModel.getDefinitions());
        }
        references.addAll(referencesModel.getReferences());
        if (!referencesModel.getDefinitions().contains(referencesModel.getReferenceAtCursor().get())) {
            references.add(referencesModel.getReferenceAtCursor().get());
        }
        return ReferencesUtil.getLocations(references, (String)context.get(DocumentServiceKeys.SOURCE_ROOT_KEY));
    }

    public static Hover getHover(LSContext context) throws WorkspaceDocumentException, CompilationFailedException {
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, true);
        if (context.get(NodeContextKeys.NODE_NAME_KEY) == null) {
            return HoverUtil.getDefaultHoverObject();
        }
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        ReferencesUtil.findReferences(modules, context);
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = referencesModel.getReferenceAtCursor();
        BSymbol bSymbol = symbolAtCursor.get().getSymbol();
        return bSymbol != null ? HoverUtil.getHoverFromDocAttachment(HoverUtil.getMarkdownDocForSymbol(bSymbol), bSymbol, context) : HoverUtil.getDefaultHoverObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BLangPackage> findCursorTokenAndCompileModules(LSContext context, boolean isQuiteMode) throws WorkspaceDocumentException, CompilationFailedException {
        String fileUri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Position position = ((TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        Boolean compileProject = (Boolean)context.get(DocumentServiceKeys.COMPILE_FULL_PROJECT);
        Optional<Path> defFilePath = CommonUtil.getPathFromURI(fileUri);
        if (!defFilePath.isPresent()) {
            return new ArrayList<BLangPackage>();
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)defFilePath.toString()).orElse(defFilePath.get());
        Optional lock = docManager.lockFile(compilationPath);
        Class<LSCustomErrorStrategy> errStrategy = LSCustomErrorStrategy.class;
        try {
            context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)fileUri);
            context.put(ReferencesKeys.REFERENCES_KEY, (Object)new SymbolReferencesModel());
            String documentContent = docManager.getFileContent(compilationPath);
            TokensUtil.searchTokenAtCursor(documentContent, context, position);
            if (context.get(NodeContextKeys.NODE_NAME_KEY) == null && !isQuiteMode) {
                throw new IllegalStateException("Couldn't find a valid identifier token at cursor!");
            }
            List list = LSModuleCompiler.getBLangPackages((LSContext)context, (WorkspaceDocumentManager)docManager, errStrategy, (boolean)compileProject, (boolean)false, (boolean)false);
            return list;
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
    }

    private static void fillAllReferences(List<BLangPackage> modules, LSContext context) {
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = referencesModel.getReferenceAtCursor();
        String symbolOwnerPkg = symbolAtCursor.get().getSymbol().pkgID.toString();
        modules.forEach(bLangPackage -> {
            List imports = bLangPackage.getImports().stream().map(bLangImportPackage -> bLangImportPackage.symbol.pkgID.toString()).collect(Collectors.toList());
            if (!symbolOwnerPkg.equals(bLangPackage.packageID.toString()) && !imports.contains(symbolOwnerPkg)) {
                return;
            }
            for (BLangCompilationUnit compilationUnit : bLangPackage.getCompilationUnits()) {
                String symbolPkgName = bLangPackage.symbol.getName().value;
                SymbolReferenceFindingVisitor refVisitor = new SymbolReferenceFindingVisitor(context, symbolPkgName);
                refVisitor.visit(compilationUnit);
            }
        });
    }

    public static void findReferences(List<BLangPackage> modules, LSContext context) {
        String currentPkgName = (String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        String relativePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        String currentCUnitName = relativePath.replace("\\", "/");
        Optional<BLangPackage> currentPkg = modules.stream().filter(pkg -> pkg.symbol.getName().getValue().equals(currentPkgName)).findAny();
        if (!currentPkg.isPresent()) {
            throw new UserErrorException("Not supported due to compilation failures!");
        }
        BLangPackage sourceOwnerPkg = CommonUtil.getSourceOwnerBLangPackage(relativePath, currentPkg.get());
        Optional<BLangCompilationUnit> currentCUnit = sourceOwnerPkg.getCompilationUnits().stream().filter(cUnit -> cUnit.name.equals(currentCUnitName)).findAny();
        SymbolReferenceFindingVisitor refVisitor = new SymbolReferenceFindingVisitor(context, currentPkgName, true);
        refVisitor.visit(currentCUnit.get());
        SymbolReferencesModel symbolReferencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        if (!symbolReferencesModel.getReferenceAtCursor().isPresent()) {
            String nodeName = (String)context.get(NodeContextKeys.NODE_NAME_KEY);
            throw new IllegalStateException("Symbol at cursor '" + nodeName + "' not supported or could not find!");
        }
        SymbolReferencesModel.Reference symbolAtCursor = symbolReferencesModel.getReferenceAtCursor().get();
        BSymbol cursorSymbol = symbolAtCursor.getSymbol();
        symbolReferencesModel.getDefinitions().removeIf(reference -> reference.getSymbol() != cursorSymbol && reference.getSymbol().type.tsymbol != cursorSymbol);
        symbolReferencesModel.getReferences().removeIf(reference -> reference.getSymbol() != cursorSymbol && reference.getSymbol().type.tsymbol != cursorSymbol);
    }

    public static List<Location> getLocations(List<SymbolReferencesModel.Reference> references, String sourceRoot) {
        return references.stream().map(reference -> {
            DiagnosticPos position = reference.getPosition();
            Path baseRoot = reference.getSourcePkgName().equals(".") ? Paths.get(sourceRoot, new String[0]) : Paths.get(sourceRoot, new String[0]).resolve("src").resolve(reference.getSourcePkgName());
            String fileURI = baseRoot.resolve(reference.getCompilationUnit()).toUri().toString();
            return new Location(fileURI, ReferencesUtil.getRange(position));
        }).collect(Collectors.toList());
    }

    private static WorkspaceEdit getWorkspaceEdit(SymbolReferencesModel referencesModel, LSContext context, String newName) {
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        SymbolReferencesModel.Reference symbolAtCursor = referencesModel.getReferenceAtCursor().get();
        ArrayList<SymbolReferencesModel.Reference> references = new ArrayList<SymbolReferencesModel.Reference>();
        references.add(symbolAtCursor);
        if (!referencesModel.getDefinitions().contains(symbolAtCursor)) {
            references.addAll(referencesModel.getDefinitions());
        }
        references.addAll(referencesModel.getReferences());
        LSDocumentIdentifier sourceDoc = (LSDocumentIdentifier)context.get(DocumentServiceKeys.LS_DOCUMENT_KEY);
        references.forEach(reference -> {
            DiagnosticPos referencePos = reference.getPosition();
            String pkgName = reference.getSourcePkgName();
            String cUnitName = reference.getCompilationUnit();
            Path basePath = sourceDoc.getProjectRootPath();
            if (sourceDoc.isWithinProject()) {
                basePath = basePath.resolve("src").resolve(pkgName);
            }
            basePath = basePath.resolve(cUnitName);
            String uri = basePath.toUri().toString();
            TextEdit textEdit = new TextEdit(ReferencesUtil.getRange(referencePos), newName);
            if (workspaceEdit.getChanges().containsKey(uri)) {
                ((List)workspaceEdit.getChanges().get(uri)).add(textEdit);
            } else {
                ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
                textEdits.add(textEdit);
                workspaceEdit.getChanges().put(uri, textEdits);
            }
        });
        return workspaceEdit;
    }

    private static Range getRange(DiagnosticPos referencePos) {
        Position start = new Position(referencePos.sLine, referencePos.sCol);
        Position end = new Position(referencePos.eLine, referencePos.eCol);
        return new Range(start, end);
    }
}

