/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.references;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class SymbolReferenceFindingVisitor
extends LSNodeVisitor {
    protected LSContext lsContext;
    protected SymbolReferencesModel symbolReferences;
    protected String tokenName;
    protected int cursorLine;
    protected int cursorCol;
    protected boolean currentCUnitMode;
    protected String pkgName;
    protected boolean doNotSkipNullSymbols = false;
    protected List<TopLevelNode> topLevelNodes = new ArrayList<TopLevelNode>();
    private List<BLangFunction> workerLambdas = new ArrayList<BLangFunction>();
    private List<BLangTypeDefinition> anonTypeDefinitions = new ArrayList<BLangTypeDefinition>();
    private HashMap<BSymbol, DiagnosticPos> workerVarDefMap = new HashMap();

    public SymbolReferenceFindingVisitor(LSContext lsContext, String pkgName, boolean currentCUnitMode) {
        this.lsContext = lsContext;
        Boolean bDoNotSkipNullSymbols = (Boolean)lsContext.get(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS);
        this.doNotSkipNullSymbols = bDoNotSkipNullSymbols == null ? false : bDoNotSkipNullSymbols;
        this.symbolReferences = (SymbolReferencesModel)lsContext.get(ReferencesKeys.REFERENCES_KEY);
        this.tokenName = (String)lsContext.get(NodeContextKeys.NODE_NAME_KEY);
        TextDocumentPositionParams position = (TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY);
        if (position == null) {
            throw new IllegalStateException("Position information not available in the Operation Context");
        }
        this.cursorLine = position.getPosition().getLine();
        this.cursorCol = position.getPosition().getCharacter();
        this.currentCUnitMode = currentCUnitMode;
        this.pkgName = pkgName;
    }

    public SymbolReferenceFindingVisitor(LSContext lsContext, String pkgName) {
        this(lsContext, pkgName, false);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
        String currentPkgName = (String)this.lsContext.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        String currentCUnitName = (String)this.lsContext.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        if (currentPkgName.equals(this.pkgName) && currentCUnitName.equals(compUnit.name) && !this.currentCUnitMode) {
            return;
        }
        this.topLevelNodes = compUnit.getTopLevelNodes();
        List<TopLevelNode> filteredNodes = this.topLevelNodes.stream().filter(topLevelNode -> {
            if (topLevelNode instanceof BLangFunction) {
                if (((BLangFunction)topLevelNode).flagSet.contains(Flag.WORKER)) {
                    this.workerLambdas.add((BLangFunction)topLevelNode);
                    return false;
                }
                return !((BLangFunction)topLevelNode).flagSet.contains(Flag.LAMBDA);
            }
            if (topLevelNode instanceof BLangTypeDefinition && ((BLangTypeDefinition)topLevelNode).flagSet.contains(Flag.ANONYMOUS)) {
                this.anonTypeDefinitions.add((BLangTypeDefinition)topLevelNode);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        filteredNodes.forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode));
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        if (xmlnsNode.prefix.value.equals(this.tokenName)) {
            DiagnosticPos pos = xmlnsNode.getPrefix().getPosition();
            this.addSymbol((BLangNode)xmlnsNode, xmlnsNode.symbol, true, pos);
        }
    }

    @Override
    public void visit(BLangConstant constant) {
        if (constant.name.value.equals(this.tokenName)) {
            DiagnosticPos pos = (DiagnosticPos)constant.getName().getPosition();
            this.addSymbol((BLangNode)constant, (BSymbol)constant.symbol, true, pos);
        }
        this.acceptNode((BLangNode)constant.typeNode);
    }

    @Override
    public void visit(BLangService serviceNode) {
        BLangType typeNode;
        if (serviceNode.name.value.equals(this.tokenName)) {
            Optional<BVarSymbol> serviceVarSymbol = this.getServiceVarSymbol();
            if (!serviceVarSymbol.isPresent()) {
                return;
            }
            DiagnosticPos pos = serviceNode.getName().getPosition();
            this.addSymbol((BLangNode)serviceNode, (BSymbol)serviceVarSymbol.get(), true, pos);
        }
        serviceNode.annAttachments.forEach(this::acceptNode);
        if (serviceNode.attachedExprs != null) {
            serviceNode.attachedExprs.forEach(this::acceptNode);
        }
        if ((typeNode = serviceNode.getTypeDefinition().typeNode) instanceof BLangObjectTypeNode) {
            ((BLangObjectTypeNode)typeNode).functions.forEach(this::acceptNode);
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        String funcName;
        boolean isWorker = funcNode.flagSet.contains(Flag.WORKER);
        String string = funcName = isWorker ? funcNode.defaultWorkerName.value : funcNode.name.value;
        if (funcName.equals(this.tokenName) || "__init".equals(funcName) && "new".equals(this.tokenName)) {
            this.addBLangFunctionSymbol(funcNode);
        }
        funcNode.annAttachments.forEach(this::acceptNode);
        funcNode.requiredParams.forEach(this::acceptNode);
        this.acceptNode((BLangNode)funcNode.restParam);
        funcNode.returnTypeAnnAttachments.forEach(this::acceptNode);
        this.acceptNode((BLangNode)funcNode.returnTypeNode);
        if (!isWorker && funcNode.body instanceof BLangBlockFunctionBody) {
            this.fillVisibleWorkerVarDefMaps(((BLangBlockFunctionBody)funcNode.body).stmts);
        }
        this.acceptNode((BLangNode)funcNode.body);
        if (!isWorker) {
            this.workerVarDefMap.clear();
        }
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.flagSet.contains(Flag.SERVICE) || typeDefinition.name.value.contains("$")) {
            return;
        }
        if (typeDefinition.name.value.equals(this.tokenName) || "new".equals(this.tokenName) && typeDefinition.symbol instanceof BObjectTypeSymbol && ((BObjectTypeSymbol)typeDefinition.symbol).initializerFunc == null) {
            DiagnosticPos pos = typeDefinition.getName().getPosition();
            this.addSymbol((BLangNode)typeDefinition, (BSymbol)typeDefinition.symbol, true, pos);
        }
        typeDefinition.annAttachments.forEach(this::acceptNode);
        this.acceptNode((BLangNode)typeDefinition.typeNode);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.getStatements().forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        blockFuncBody.stmts.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        this.acceptNode((BLangNode)exprFuncBody.getExpr());
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        for (BLangAnnotationAttachment annAttachment : body.annAttachments) {
            this.acceptNode((BLangNode)annAttachment);
        }
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.acceptNode((BLangNode)ifNode.expr);
        this.acceptNode((BLangNode)ifNode.body);
        if (ifNode.elseStmt != null) {
            this.acceptNode((BLangNode)ifNode.elseStmt);
        }
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.acceptNode((BLangNode)foreach.collection);
        this.acceptNode((BLangNode)foreach.variableDefinitionNode);
        this.acceptNode((BLangNode)foreach.body);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.acceptNode((BLangNode)whileNode.expr);
        this.acceptNode((BLangNode)whileNode.body);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        forkJoin.workers.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.acceptNode((BLangNode)transactionNode.retryCount);
        this.acceptNode((BLangNode)transactionNode.transactionBody);
        this.acceptNode((BLangNode)transactionNode.onRetryBody);
        this.acceptNode((BLangNode)transactionNode.committedBody);
        this.acceptNode((BLangNode)transactionNode.abortedBody);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.acceptNode((BLangNode)lockNode.body);
    }

    @Override
    public void visit(BLangMatch matchNode) {
        this.acceptNode((BLangNode)matchNode.expr);
        matchNode.patternClauses.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause staticBindingPatternClause) {
        this.acceptNode((BLangNode)staticBindingPatternClause.literal);
        this.acceptNode((BLangNode)staticBindingPatternClause.body);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause structuredBindingPatternClause) {
        super.visit(structuredBindingPatternClause);
        this.acceptNode((BLangNode)structuredBindingPatternClause.bindingPatternVariable);
        this.acceptNode((BLangNode)structuredBindingPatternClause.body);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        bLangRecordVariable.variableList.forEach(variableKeyValue -> this.acceptNode((BLangNode)variableKeyValue.valueBindingPattern));
        if (bLangRecordVariable.restParam instanceof BLangNode) {
            this.acceptNode((BLangNode)bLangRecordVariable.restParam);
        }
        this.acceptNode((BLangNode)bLangRecordVariable.expr);
        this.acceptNode((BLangNode)bLangRecordVariable.typeNode);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BLangType typeNode = varNode.typeNode;
        if (varNode.flagSet.contains(Flag.SERVICE)) {
            return;
        }
        if (varNode.name.value.equals(this.tokenName)) {
            DiagnosticPos pos = varNode.name.getPosition();
            this.addSymbol((BLangNode)varNode, (BSymbol)varNode.symbol, true, pos);
        } else {
            this.acceptNode((BLangNode)typeNode);
        }
        varNode.annAttachments.forEach(this::acceptNode);
        this.acceptNode((BLangNode)varNode.expr);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.acceptNode((BLangNode)bLangErrorVariable.typeNode);
        this.acceptNode((BLangNode)bLangErrorVariable.reason);
        for (BLangErrorVariable.BLangErrorDetailEntry bLangErrorDetailEntry : bLangErrorVariable.detail) {
            this.acceptNode((BLangNode)bLangErrorDetailEntry.valueBindingPattern);
        }
        this.acceptNode((BLangNode)bLangErrorVariable.restDetail);
        this.acceptNode((BLangNode)bLangErrorVariable.expr);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        bLangTupleVariable.memberVariables.forEach(this::acceptNode);
        this.acceptNode((BLangNode)bLangTupleVariable.getRestVariable());
        this.acceptNode((BLangNode)bLangTupleVariable.typeNode);
        this.acceptNode((BLangNode)bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        BLangSimpleVariable variable = varDefNode.var;
        BLangType typeNode = variable.typeNode;
        if (varDefNode.isWorker) {
            if (varDefNode.var.expr instanceof BLangLambdaFunction && ((BLangLambdaFunction)varDefNode.var.expr).function.flagSet.contains(Flag.WORKER)) {
                return;
            }
            Optional<BLangFunction> workerFunction = this.getWorkerFunctionFromPosition(variable.pos);
            workerFunction.ifPresent(this::acceptNode);
            return;
        }
        if (variable.name.value.equals(this.tokenName)) {
            DiagnosticPos pos = variable.getName().getPosition();
            this.addSymbol((BLangNode)variable, (BSymbol)variable.symbol, true, pos);
        } else {
            this.acceptNode((BLangNode)typeNode);
        }
        this.acceptNode((BLangNode)varDefNode.var.expr);
    }

    @Override
    public void visit(BLangConstRef constRef) {
        if (constRef.variableName != null && constRef.variableName.value.equals(this.tokenName)) {
            this.addSymbol((BLangNode)constRef, constRef.symbol, false, constRef.pos);
        }
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.acceptNode((BLangNode)bLangErrorVariableDef.errorVariable);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.acceptNode((BLangNode)bLangTupleVariableDef.var);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        stmt.varRef.expressions.forEach(this::acceptNode);
        this.acceptNode((BLangNode)stmt.expr);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.acceptNode((BLangNode)stmt.varRef);
        this.acceptNode((BLangNode)stmt.expr);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.acceptNode((BLangNode)panicNode.expr);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.acceptNode((BLangNode)bLangRecordVariableDef.var);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.acceptNode((BLangNode)assignNode.varRef);
        this.acceptNode((BLangNode)assignNode.expr);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.acceptNode((BLangNode)compoundAssignNode.varRef);
        this.acceptNode((BLangNode)compoundAssignNode.expr);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (varRefExpr.getVariableName().value.equals(this.tokenName)) {
            DiagnosticPos pos = varRefExpr.getVariableName().getPosition();
            this.addSymbol((BLangNode)varRefExpr, varRefExpr.symbol, false, pos);
        } else if (varRefExpr.pkgAlias != null && varRefExpr.pkgAlias.value.equals(this.tokenName)) {
            DiagnosticPos pos = varRefExpr.pkgAlias.getPosition();
            this.addSymbol((BLangNode)varRefExpr, varRefExpr.pkgSymbol, false, pos);
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.acceptNode((BLangNode)indexAccessExpr.expr);
        if (!(indexAccessExpr.indexExpr instanceof BLangLiteral)) {
            this.acceptNode((BLangNode)indexAccessExpr.indexExpr);
        }
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.acceptNode((BLangNode)fieldAccessExpr.expr);
        if (fieldAccessExpr.field.value.equals(this.tokenName)) {
            DiagnosticPos symbolPos = fieldAccessExpr.getFieldName().getPosition();
            this.addSymbol((BLangNode)fieldAccessExpr, fieldAccessExpr.symbol, false, symbolPos);
        }
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.acceptNode((BLangNode)xmlAttributeAccessExpr.expr);
        this.acceptNode((BLangNode)xmlAttributeAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        varRefExpr.expressions.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        varRefExpr.recordRefFields.forEach(varRefKeyVal -> this.acceptNode((BLangNode)varRefKeyVal.variableReference));
        if (varRefExpr.restParam instanceof BLangSimpleVarRef) {
            this.acceptNode((BLangNode)((BLangSimpleVarRef)varRefExpr.restParam));
        }
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.acceptNode((BLangNode)arrayType.elemtype);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
        super.visit(builtInRefType);
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.acceptNode((BLangNode)constrainedType.type);
        this.acceptNode((BLangNode)constrainedType.constraint);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        Optional<BLangTypeDefinition> anonType = this.getAnonTypeFromPosition(userDefinedType.pos);
        if (anonType.isPresent()) {
            this.acceptNode((BLangNode)anonType.get().typeNode);
            return;
        }
        if (!this.isMatchingUserDefinedType(userDefinedType)) {
            return;
        }
        DiagnosticPos position = userDefinedType.getTypeName().getPosition();
        this.addSymbol((BLangNode)userDefinedType, (BSymbol)userDefinedType.type.tsymbol, false, position);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        functionTypeNode.params.forEach(this::acceptNode);
        this.acceptNode((BLangNode)functionTypeNode.returnTypeNode);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        unionTypeNode.getMemberTypeNodes().forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        objectTypeNode.typeRefs.forEach(this::addObjectReferenceType);
        objectTypeNode.fields.forEach(this::acceptNode);
        objectTypeNode.functions.forEach(this::acceptNode);
        this.acceptNode((BLangNode)objectTypeNode.initFunction);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        recordTypeNode.fields.forEach(this::acceptNode);
        recordTypeNode.typeRefs.forEach(this::acceptNode);
        this.acceptNode((BLangNode)recordTypeNode.restFieldType);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        tupleTypeNode.memberTypeNodes.forEach(this::acceptNode);
        this.acceptNode((BLangNode)tupleTypeNode.restParamType);
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.acceptNode((BLangNode)errorType.reasonType);
        this.acceptNode((BLangNode)errorType.detailType);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.acceptNode((BLangNode)typeTestExpr.expr);
        this.acceptNode((BLangNode)typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.acceptNode((BLangNode)ternaryExpr.expr);
        this.acceptNode((BLangNode)ternaryExpr.thenExpr);
        this.acceptNode((BLangNode)ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        BLangFunction funcNode = bLangLambdaFunction.function;
        funcNode.annAttachments.forEach(this::acceptNode);
        funcNode.requiredParams.forEach(this::acceptNode);
        if (funcNode.restParam != null) {
            this.acceptNode((BLangNode)funcNode.restParam);
            this.acceptNode((BLangNode)funcNode.restParam.typeNode);
        }
        funcNode.returnTypeAnnAttachments.forEach(this::acceptNode);
        this.acceptNode((BLangNode)funcNode.returnTypeNode);
        this.acceptNode((BLangNode)funcNode.body);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.acceptNode((BLangNode)exprStmtNode.expr);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.acceptNode((BLangNode)invocationExpr.expr);
        if (invocationExpr.getName().getValue().equals(this.tokenName)) {
            DiagnosticPos symbolPos = (DiagnosticPos)invocationExpr.getName().getPosition();
            if (invocationExpr.symbol != null && invocationExpr.type.tsymbol != null && invocationExpr.symbol.type.tag == 27) {
                this.addSymbol((BLangNode)invocationExpr, (BSymbol)invocationExpr.type.tsymbol, false, symbolPos);
            } else {
                this.addSymbol((BLangNode)invocationExpr, invocationExpr.symbol, false, symbolPos);
            }
        }
        invocationExpr.requiredArgs.forEach(this::acceptNode);
        invocationExpr.argExprs.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.acceptNode((BLangNode)groupExpr.expression);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.acceptNode((BLangNode)binaryExpr.lhsExpr);
        this.acceptNode((BLangNode)binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.acceptNode((BLangNode)checkedExpr.expr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.acceptNode((BLangNode)checkPanickedExpr.expr);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        awaitExpr.exprList.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.exprs.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        recordLiteral.fields.forEach(field -> {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField bLangRecordKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                this.acceptNode((BLangNode)bLangRecordKeyValue.key.expr);
                this.acceptNode((BLangNode)bLangRecordKeyValue.valueExpr);
            } else if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                this.acceptNode((BLangNode)((BLangRecordLiteral.BLangRecordSpreadOperatorField)field));
            } else {
                this.acceptNode((BLangNode)((BLangRecordLiteral.BLangRecordVarNameField)field));
            }
        });
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.acceptNode((BLangNode)returnNode.expr);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.acceptNode((BLangNode)conversionExpr.typeNode);
        this.acceptNode((BLangNode)conversionExpr.expr);
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        if (typeInit.initInvocation != null && typeInit.initInvocation.name.value.equals(this.tokenName)) {
            BSymbol symbol = typeInit.initInvocation.symbol;
            if (symbol == null) {
                symbol = typeInit.type.tsymbol;
            }
            this.addSymbol((BLangNode)typeInit.initInvocation, symbol, false, typeInit.initInvocation.name.pos);
        } else if (typeInit.userDefinedType != null) {
            this.acceptNode((BLangNode)typeInit.userDefinedType);
        }
        typeInit.argsExpr.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.acceptNode((BLangNode)bLangNamedArgsExpression.expr);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(this::acceptNode);
        if (annotationNode.name.value.equals(this.tokenName)) {
            DiagnosticPos pos = (DiagnosticPos)annotationNode.getName().getPosition();
            this.addSymbol((BLangNode)annotationNode, annotationNode.symbol, true, pos);
        }
        this.acceptNode((BLangNode)annotationNode.typeNode);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        if (annAttachmentNode.annotationName.value.equals(this.tokenName)) {
            DiagnosticPos pos = (DiagnosticPos)annAttachmentNode.getAnnotationName().getPosition();
            this.addSymbol((BLangNode)annAttachmentNode, (BSymbol)annAttachmentNode.annotationSymbol, false, pos);
        }
        this.acceptNode((BLangNode)annAttachmentNode.expr);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.acceptNode((BLangNode)unaryExpr.expr);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.acceptNode((BLangNode)annotAccessExpr.expr);
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        this.acceptNode((BLangNode)workerSendNode.expr);
        if (workerSendNode.workerIdentifier.value.equals(this.tokenName)) {
            DiagnosticPos pos = workerSendNode.getWorkerName().getPosition();
            this.addSymbol((BLangNode)workerSendNode, this.getWorkerSymbolForName(this.tokenName), false, pos);
        }
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.acceptNode((BLangNode)syncSendExpr.expr);
        if (syncSendExpr.workerIdentifier.value.equals(this.tokenName)) {
            DiagnosticPos pos = (DiagnosticPos)syncSendExpr.getWorkerName().getPosition();
            this.addSymbol((BLangNode)syncSendExpr, this.getWorkerSymbolForName(this.tokenName), false, pos);
        }
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        if (workerReceiveNode.workerIdentifier.value.equals(this.tokenName)) {
            DiagnosticPos pos = workerReceiveNode.getWorkerName().getPosition();
            this.addSymbol((BLangNode)workerReceiveNode, this.getWorkerSymbolForName(this.tokenName), false, pos);
        }
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        if (workerFlushExpr.workerIdentifier.value.equals(this.tokenName)) {
            DiagnosticPos pos = workerFlushExpr.workerIdentifier.getPosition();
            this.addSymbol((BLangNode)workerFlushExpr, this.getWorkerSymbolForName(this.tokenName), false, pos);
        }
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.acceptNode((BLangNode)bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.acceptNode((BLangNode)accessExpr.typeNode);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        bLangArrowFunction.params.forEach(this::acceptNode);
        this.acceptNode((BLangNode)bLangArrowFunction.body.expr);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.acceptNode((BLangNode)elvisExpr.lhsExpr);
        this.acceptNode((BLangNode)elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.acceptNode((BLangNode)trapExpr.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.getKeyValuePairs().forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        this.acceptNode((BLangNode)waitKeyValue.keyExpr);
        this.acceptNode((BLangNode)waitKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.acceptNode((BLangNode)stmt.varRef);
        this.acceptNode((BLangNode)stmt.expr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        this.acceptNode((BLangNode)spreadOperatorField.expr);
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.acceptNode((BLangNode)varRefExpr.typeNode);
        this.acceptNode((BLangNode)varRefExpr.reason);
        varRefExpr.detail.forEach(bLangNamedArgsExpression -> this.acceptNode((BLangNode)bLangNamedArgsExpression.expr));
        this.acceptNode((BLangNode)varRefExpr.restVar);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        queryExpr.fromClauseList.forEach(this::acceptNode);
        queryExpr.letClausesList.forEach(this::acceptNode);
        this.acceptNode((BLangNode)queryExpr.selectClause);
        queryExpr.whereClauseList.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        queryAction.fromClauseList.forEach(this::acceptNode);
        queryAction.whereClauseList.forEach(this::acceptNode);
        queryAction.getLetClauseNode().forEach(this::acceptNode);
        this.acceptNode((BLangNode)queryAction.doClause);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.acceptNode((BLangNode)doClause.body);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.acceptNode((BLangNode)fromClause.collection);
        this.acceptNode((BLangNode)fromClause.variableDefinitionNode);
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.acceptNode((BLangNode)selectClause.expression);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.acceptNode((BLangNode)whereClause.expression);
    }

    @Override
    public void visit(BLangLetClause letClause) {
        letClause.letVarDeclarations.forEach(bLangLetVariable -> this.acceptNode((BLangNode)bLangLetVariable.definitionNode));
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        letExpr.letVarDeclarations.forEach(bLangLetVariable -> this.acceptNode((BLangNode)bLangLetVariable.definitionNode));
        this.acceptNode((BLangNode)letExpr.expr);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.acceptNode((BLangNode)streamType.constraint);
        this.acceptNode((BLangNode)streamType.error);
    }

    protected void acceptNode(BLangNode node) {
        if (node == null) {
            return;
        }
        node.accept((BLangNodeVisitor)this);
    }

    private boolean isMatchingUserDefinedType(BLangUserDefinedType bType) {
        return bType.typeName.value.equals(this.tokenName);
    }

    protected SymbolReferencesModel.Reference getSymbolReference(DiagnosticPos position, BSymbol symbol, BLangNode bLangNode) {
        return new SymbolReferencesModel.Reference(position, symbol, bLangNode);
    }

    protected void addSymbol(BLangNode bLangNode, BSymbol bSymbol, boolean isDefinition, DiagnosticPos position) {
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = this.symbolReferences.getReferenceAtCursor();
        if (bSymbol == null && !this.doNotSkipNullSymbols) {
            return;
        }
        if (!this.currentCUnitMode && symbolAtCursor.isPresent() && symbolAtCursor.get().getSymbol() != bSymbol) {
            return;
        }
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(position);
        bSymbol = bSymbol instanceof BVarSymbol && ((BVarSymbol)bSymbol).originalSymbol != null ? ((BVarSymbol)bSymbol).originalSymbol : bSymbol;
        SymbolReferencesModel.Reference ref = this.getSymbolReference(zeroBasedPos, bSymbol, bLangNode);
        if (this.currentCUnitMode && this.cursorLine == zeroBasedPos.sLine && this.cursorCol >= zeroBasedPos.sCol && this.cursorCol <= zeroBasedPos.eCol) {
            this.symbolReferences.setReferenceAtCursor(ref);
            if (isDefinition) {
                this.symbolReferences.addDefinition(ref);
            }
            return;
        }
        if (isDefinition) {
            this.symbolReferences.addDefinition(ref);
            return;
        }
        this.symbolReferences.addReference(ref);
    }

    private Optional<BVarSymbol> getServiceVarSymbol() {
        return this.topLevelNodes.stream().filter(node -> node instanceof BLangSimpleVariable && this.tokenName.equals(((BLangSimpleVariable)node).name.value)).map(topLevelNode -> ((BLangSimpleVariable)topLevelNode).symbol).findAny();
    }

    private void addBLangFunctionSymbol(BLangFunction funcNode) {
        boolean isDefinition = !funcNode.flagSet.contains(Flag.INTERFACE);
        DiagnosticPos pos = funcNode.flagSet.contains(Flag.WORKER) ? funcNode.defaultWorkerName.pos : funcNode.getName().getPosition();
        BInvokableSymbol symbol = funcNode.flagSet.contains(Flag.WORKER) ? this.getWorkerSymbolForPosition(funcNode.defaultWorkerName.pos) : funcNode.symbol;
        this.addSymbol((BLangNode)funcNode, (BSymbol)symbol, isDefinition, pos);
    }

    private Optional<BLangFunction> getWorkerFunctionFromPosition(DiagnosticPos position) {
        return this.workerLambdas.stream().filter(function -> function.defaultWorkerName.getPosition() == position).findAny();
    }

    private Optional<BLangTypeDefinition> getAnonTypeFromPosition(DiagnosticPos position) {
        return this.anonTypeDefinitions.stream().filter(anonTypeDef -> anonTypeDef.getPosition() == position).findAny();
    }

    private void fillVisibleWorkerVarDefMaps(List<BLangStatement> statements) {
        statements.forEach(bLangStatement -> {
            if (bLangStatement instanceof BLangSimpleVariableDef && ((BLangSimpleVariableDef)bLangStatement).var.type instanceof BFutureType) {
                BLangSimpleVariable variable = ((BLangSimpleVariableDef)bLangStatement).var;
                this.workerVarDefMap.put((BSymbol)variable.symbol, bLangStatement.pos);
            }
        });
    }

    private BSymbol getWorkerSymbolForPosition(DiagnosticPos pos) {
        return this.workerVarDefMap.entrySet().stream().filter(entry -> entry.getValue() == pos).findAny().map(Map.Entry::getKey).orElse(null);
    }

    private BSymbol getWorkerSymbolForName(String name) {
        return this.workerVarDefMap.keySet().stream().filter(symbol -> symbol.name.getValue().equals(name)).findAny().orElse(null);
    }

    private void addObjectReferenceType(BLangType bLangType) {
        if (!(bLangType instanceof BLangUserDefinedType && ((BLangUserDefinedType)bLangType).typeName.getValue().equals(this.tokenName) && bLangType.type instanceof BObjectType)) {
            return;
        }
        DiagnosticPos diagnosticPos = bLangType.pos;
        BObjectType objectType = (BObjectType)bLangType.type;
        DiagnosticPos pos = new DiagnosticPos(diagnosticPos.src, diagnosticPos.sLine, diagnosticPos.eLine, diagnosticPos.sCol, diagnosticPos.eCol);
        this.addSymbol((BLangNode)bLangType, (BSymbol)objectType.tsymbol, false, pos);
    }
}

