/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.Util;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

class ProgressThread
implements Runnable {
    volatile boolean killed;
    ProgressBarStyle style;
    ProgressState progress;
    long updateInterval;
    PrintStream consoleStream;
    Terminal terminal;
    int consoleWidth = 80;
    String unitName = "";
    long unitSize = 1L;
    boolean isSpeedShown;
    private static int consoleRightMargin = 2;
    private DecimalFormat speedFormat;
    private int length;

    ProgressThread(ProgressState progress, ProgressBarStyle style, long updateInterval, PrintStream consoleStream, String unitName, long unitSize, boolean isSpeedShown, DecimalFormat speedFormat) {
        this.progress = progress;
        this.style = style;
        this.updateInterval = updateInterval;
        this.consoleStream = consoleStream;
        this.unitName = unitName;
        this.unitSize = unitSize;
        this.isSpeedShown = isSpeedShown;
        this.speedFormat = speedFormat;
        try {
            this.terminal = TerminalBuilder.builder().dumb(true).build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.terminal.getWidth() >= 10) {
            this.consoleWidth = this.terminal.getWidth();
        }
    }

    double progress() {
        if (this.progress.max <= 0L) {
            return 0.0;
        }
        return (double)this.progress.current / (double)this.progress.max;
    }

    int progressIntegralPart() {
        return (int)(this.progress() * (double)this.length);
    }

    int progressFractionalPart() {
        double p = this.progress() * (double)this.length;
        double fraction = (p - Math.floor(p)) * (double)this.style.fractionSymbols.length();
        return (int)Math.floor(fraction);
    }

    String eta(Duration elapsed) {
        if (this.progress.max <= 0L || this.progress.indefinite) {
            return "?";
        }
        if (this.progress.current == 0L) {
            return "?";
        }
        return Util.formatDuration(elapsed.dividedBy(this.progress.current).multipliedBy(this.progress.max - this.progress.current));
    }

    String percentage() {
        String res = this.progress.max <= 0L || this.progress.indefinite ? "? %" : String.valueOf((int)Math.floor(100.0 * (double)this.progress.current / (double)this.progress.max)) + "%";
        return Util.repeat(' ', 4 - res.length()) + res;
    }

    String ratio() {
        String m = this.progress.indefinite ? "?" : String.valueOf(this.progress.max / this.unitSize);
        String c = String.valueOf(this.progress.current / this.unitSize);
        return Util.repeat(' ', m.length() - c.length()) + c + "/" + m + this.unitName;
    }

    String speed(Duration elapsed) {
        if (elapsed.getSeconds() == 0L) {
            return "?" + this.unitName + "/s";
        }
        double speed = (double)this.progress.current / (double)elapsed.getSeconds();
        double speedWithUnit = speed / (double)this.unitSize;
        return this.speedFormat.format(speedWithUnit) + this.unitName + "/s";
    }

    void refresh() {
        this.consoleStream.print('\r');
        Instant currTime = Instant.now();
        Duration elapsed = Duration.between(this.progress.startTime, currTime);
        String prefix = this.progress.task + " " + this.percentage() + " " + this.style.leftBracket;
        int maxSuffixLength = Math.max(0, this.consoleWidth - consoleRightMargin - prefix.length() - 10);
        String speedString = this.isSpeedShown ? this.speed(elapsed) : "";
        String suffix = this.style.rightBracket + " " + this.ratio() + " (" + Util.formatDuration(elapsed) + " / " + this.eta(elapsed) + ") " + speedString + this.progress.extraMessage;
        if (suffix.length() > maxSuffixLength) {
            suffix = suffix.substring(0, maxSuffixLength);
        }
        this.length = this.consoleWidth - consoleRightMargin - prefix.length() - suffix.length();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (this.progress.indefinite) {
            int pos = (int)(this.progress.current % (long)this.length);
            sb.append(Util.repeat(this.style.space, pos));
            sb.append(this.style.block);
            sb.append(Util.repeat(this.style.space, this.length - pos - 1));
        } else {
            sb.append(Util.repeat(this.style.block, this.progressIntegralPart()));
            if (this.progress.current < this.progress.max) {
                sb.append(this.style.fractionSymbols.charAt(this.progressFractionalPart()));
                sb.append(Util.repeat(this.style.space, this.length - this.progressIntegralPart() - 1));
            }
        }
        sb.append(suffix);
        String line = sb.toString();
        this.consoleStream.print(line);
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.refresh();
                Thread.sleep(this.updateInterval);
            }
        }
        catch (InterruptedException ignored) {
            this.refresh();
        }
    }
}

