/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.openapi.validator.OpenAPIParameter;

class OpenAPIPathSummary {
    private String path = null;
    private List<String> availableOperations = new ArrayList<String>();
    private Map<String, Operation> operations = new HashMap<String, Operation>();

    OpenAPIPathSummary() {
    }

    String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    List<String> getAvailableOperations() {
        return this.availableOperations;
    }

    void addOperation(String method, Operation operation) {
        this.operations.put(method, operation);
    }

    void addAvailableOperation(String operation) {
        this.availableOperations.add(operation);
    }

    boolean hasTags(List<String> tags, String method) {
        Operation operation = this.operations.get(method);
        if (operation == null) {
            return false;
        }
        return operation.getTags().containsAll(tags);
    }

    List<OpenAPIParameter> getParamNamesForOperation(String operation) {
        ArrayList<OpenAPIParameter> paramNames = new ArrayList<OpenAPIParameter>();
        for (Map.Entry<String, Operation> entry : this.operations.entrySet()) {
            if (!entry.getKey().equals(operation) || entry.getValue() == null || entry.getValue().getParameters() == null) continue;
            for (Parameter parameter : entry.getValue().getParameters()) {
                if (parameter.getIn() == null || !parameter.getIn().equals("path")) continue;
                OpenAPIParameter openAPIParameter = new OpenAPIParameter();
                openAPIParameter.setName(parameter.getName());
                openAPIParameter.setParamType("path");
                openAPIParameter.setParameter(parameter);
                if (parameter.getSchema() != null) {
                    Schema schema = parameter.getSchema();
                    String type = schema.getType();
                    openAPIParameter.setType(type);
                }
                paramNames.add(openAPIParameter);
            }
        }
        return paramNames;
    }

    Map<String, Schema> getRequestBodyForOperation(String operation) {
        HashMap<String, Schema> requestBodySchemas = new HashMap<String, Schema>();
        for (Map.Entry<String, Operation> entry : this.operations.entrySet()) {
            if (!entry.getKey().equals(operation)) continue;
            if (entry.getValue().getRequestBody() == null) break;
            Content content = entry.getValue().getRequestBody().getContent();
            for (Map.Entry mediaTypeEntry : content.entrySet()) {
                requestBodySchemas.put((String)mediaTypeEntry.getKey(), ((MediaType)mediaTypeEntry.getValue()).getSchema());
            }
        }
        return requestBodySchemas;
    }
}

