/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.openapi.validator.OpenAPIComponentSummary;
import org.ballerinalang.openapi.validator.OpenAPIPathSummary;
import org.ballerinalang.openapi.validator.OpenApiValidatorException;
import org.ballerinalang.openapi.validator.ResourceSummary;
import org.ballerinalang.openapi.validator.ValidatorUtil;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

@SupportedAnnotationPackages(value={"ballerina/openapi"})
public class OpenAPIValidatorPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dLog = null;
    private List<ResourceSummary> resourceSummaryList;
    private List<OpenAPIPathSummary> openAPISummaryList;
    private OpenAPIComponentSummary openAPIComponentSummary;

    public void init(DiagnosticLog diagnosticLog) {
        this.dLog = diagnosticLog;
        this.resourceSummaryList = new ArrayList<ResourceSummary>();
        this.openAPISummaryList = new ArrayList<OpenAPIPathSummary>();
        this.openAPIComponentSummary = new OpenAPIComponentSummary();
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode annotation = null;
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> operations = new ArrayList<String>();
        this.openAPIComponentSummary = new OpenAPIComponentSummary();
        String contractURI = null;
        for (AnnotationAttachmentNode ann : annotations) {
            if (!"openapi".equals(ann.getPackageAlias().getValue()) || !"ServiceInfo".equals(ann.getAnnotationName().getValue())) continue;
            annotation = ann;
        }
        if (annotation != null) {
            if (annotation.getExpression() instanceof BLangRecordLiteral) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                for (BLangRecordLiteral.BLangRecordKeyValue keyValue : recordLiteral.getKeyValuePairs()) {
                    BLangLiteral expression;
                    BLangListConstructorExpr bLangListConstructorExpr;
                    if (!(keyValue.getKey() instanceof BLangSimpleVarRef)) continue;
                    BLangSimpleVarRef contract = (BLangSimpleVarRef)keyValue.getKey();
                    String key = contract.getVariableName().getValue();
                    if (key.equals("contract")) {
                        if (!(keyValue.getValue() instanceof BLangLiteral)) continue;
                        BLangLiteral value = (BLangLiteral)keyValue.getValue();
                        if (value.getValue() instanceof String) {
                            contractURI = (String)value.getValue();
                            continue;
                        }
                        this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)"Contract path should be applied as a string value");
                        continue;
                    }
                    if (key.equals("tags")) {
                        if (!(keyValue.getValue() instanceof BLangListConstructorExpr)) continue;
                        bLangListConstructorExpr = (BLangListConstructorExpr)keyValue.getValue();
                        for (BLangExpression bLangExpression : bLangListConstructorExpr.getExpressions()) {
                            if (!(bLangExpression instanceof BLangLiteral)) continue;
                            expression = (BLangLiteral)bLangExpression;
                            if (expression.getValue() instanceof String) {
                                tags.add((String)expression.getValue());
                                continue;
                            }
                            this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)"Tags should be applied as string values");
                        }
                        continue;
                    }
                    if (!key.equals("operations") || !(keyValue.getValue() instanceof BLangListConstructorExpr)) continue;
                    bLangListConstructorExpr = (BLangListConstructorExpr)keyValue.getValue();
                    for (BLangExpression bLangExpression : bLangListConstructorExpr.getExpressions()) {
                        if (!(bLangExpression instanceof BLangLiteral)) continue;
                        expression = (BLangLiteral)bLangExpression;
                        if (expression.getValue() instanceof String) {
                            operations.add((String)expression.getValue());
                            continue;
                        }
                        this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)"Operations should be applied as string values");
                    }
                }
            }
            if (contractURI != null) {
                try {
                    OpenAPI openAPI = ValidatorUtil.parseOpenAPIFile(contractURI);
                    ValidatorUtil.summarizeResources(this.resourceSummaryList, serviceNode);
                    ValidatorUtil.summarizeOpenAPI(this.openAPISummaryList, openAPI, this.openAPIComponentSummary);
                    ValidatorUtil.validateOpenApiAgainstResources(serviceNode, tags, operations, this.resourceSummaryList, this.openAPISummaryList, this.openAPIComponentSummary, this.dLog);
                    ValidatorUtil.validateResourcesAgainstOpenApi(tags, operations, this.resourceSummaryList, this.openAPISummaryList, this.openAPIComponentSummary, this.dLog);
                }
                catch (OpenApiValidatorException e) {
                    this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)e.getMessage());
                }
            }
        }
    }

    public void process(PackageNode packageNode) {
    }
}

