/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.openapi.validator.OpenAPIComponentSummary;
import org.ballerinalang.openapi.validator.OpenAPIParameter;
import org.ballerinalang.openapi.validator.OpenAPIPathSummary;
import org.ballerinalang.openapi.validator.OpenApiValidatorException;
import org.ballerinalang.openapi.validator.ResourceParameter;
import org.ballerinalang.openapi.validator.ResourceSummary;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

class ValidatorUtil {
    ValidatorUtil() {
    }

    static OpenAPI parseOpenAPIFile(String definitionURI) throws OpenApiValidatorException {
        Path contractPath = java.nio.file.Paths.get(definitionURI, new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            throw new OpenApiValidatorException("OpenAPI contract doesn't exist in the given location:\n" + definitionURI);
        }
        if (!definitionURI.endsWith(".yaml") && !definitionURI.endsWith(".json")) {
            throw new OpenApiValidatorException("Invalid file type. Provide either a .yaml or .json file.");
        }
        OpenAPI api = new OpenAPIV3Parser().read(definitionURI);
        if (api == null) {
            throw new OpenApiValidatorException("Couldn't read the definition from file: " + definitionURI);
        }
        return api;
    }

    static void summarizeOpenAPI(List<OpenAPIPathSummary> openAPISummaries, OpenAPI contract, OpenAPIComponentSummary openAPIComponentSummary) {
        Paths paths = contract.getPaths();
        for (Map.Entry pathItem : paths.entrySet()) {
            OpenAPIPathSummary openAPISummary = new OpenAPIPathSummary();
            if (pathItem.getKey() instanceof String && pathItem.getValue() instanceof PathItem) {
                String key = (String)pathItem.getKey();
                openAPISummary.setPath(key);
                PathItem operations = (PathItem)pathItem.getValue();
                if (operations.getGet() != null) {
                    openAPISummary.addAvailableOperation("get");
                    openAPISummary.addOperation("get", operations.getGet());
                }
                if (operations.getPost() != null) {
                    openAPISummary.addAvailableOperation("post");
                    openAPISummary.addOperation("post", operations.getPost());
                }
                if (operations.getPut() != null) {
                    openAPISummary.addAvailableOperation("put");
                    openAPISummary.addOperation("put", operations.getPut());
                }
                if (operations.getDelete() != null) {
                    openAPISummary.addAvailableOperation("delete");
                    openAPISummary.addOperation("delete", operations.getDelete());
                }
                if (operations.getHead() != null) {
                    openAPISummary.addAvailableOperation("head");
                    openAPISummary.addOperation("head", operations.getHead());
                }
                if (operations.getPatch() != null) {
                    openAPISummary.addAvailableOperation("patch");
                    openAPISummary.addOperation("patch", operations.getPatch());
                }
                if (operations.getOptions() != null) {
                    openAPISummary.addAvailableOperation("options");
                    openAPISummary.addOperation("options", operations.getOptions());
                }
                if (operations.getTrace() != null) {
                    openAPISummary.addAvailableOperation("trace");
                    openAPISummary.addOperation("trace", operations.getTrace());
                }
            }
            openAPISummaries.add(openAPISummary);
        }
        openAPIComponentSummary.setComponents(contract.getComponents());
    }

    static void summarizeResources(List<ResourceSummary> resourceSummaryList, ServiceNode serviceNode) {
        for (FunctionNode resource : serviceNode.getResources()) {
            AnnotationAttachmentNode annotation = null;
            ResourceSummary resourceSummary = new ResourceSummary();
            resourceSummary.setResourcePosition(resource.getPosition());
            for (AnnotationAttachmentNode ann : resource.getAnnotationAttachments()) {
                if (!"http".equals(ann.getPackageAlias().getValue()) || !"ResourceConfig".equals(ann.getAnnotationName().getValue())) continue;
                annotation = ann;
            }
            if (annotation != null && annotation.getExpression() instanceof BLangRecordLiteral) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                for (BLangRecordLiteral.BLangRecordKeyValue keyValue : recordLiteral.getKeyValuePairs()) {
                    BLangLiteral value;
                    if (!(keyValue.getKey() instanceof BLangSimpleVarRef)) continue;
                    BLangSimpleVarRef path = (BLangSimpleVarRef)keyValue.getKey();
                    String contractAttr = path.getVariableName().getValue();
                    if (contractAttr.equals("path")) {
                        if (!(keyValue.getValue() instanceof BLangLiteral) || !((value = (BLangLiteral)keyValue.getValue()).getValue() instanceof String)) continue;
                        resourceSummary.setPath((String)value.getValue());
                        resourceSummary.setPathPosition((Diagnostic.DiagnosticPosition)value.getPosition());
                        continue;
                    }
                    if (contractAttr.equals("methods")) {
                        if (!(keyValue.getValue() instanceof BLangListConstructorExpr)) continue;
                        BLangListConstructorExpr methodSet = (BLangListConstructorExpr)keyValue.getValue();
                        for (BLangExpression methodExpr : methodSet.exprs) {
                            if (!(methodExpr instanceof BLangLiteral)) continue;
                            BLangLiteral method = (BLangLiteral)methodExpr;
                            resourceSummary.addMethod(((String)method.value).toLowerCase(Locale.ENGLISH));
                            resourceSummary.setMethodsPosition((Diagnostic.DiagnosticPosition)methodSet.getPosition());
                        }
                        continue;
                    }
                    if (!contractAttr.equals("body") || !(keyValue.getValue() instanceof BLangLiteral) || !((value = (BLangLiteral)keyValue.getValue()).getValue() instanceof String)) continue;
                    resourceSummary.setBody((String)value.getValue());
                }
            }
            if (resource.getParameters().size() > 0) {
                resourceSummary.setParameters(resource.getParameters());
            }
            resourceSummaryList.add(resourceSummary);
        }
    }

    static void validateResourcesAgainstOpenApi(List<String> tags, List<String> operations, List<ResourceSummary> resourceSummaryList, List<OpenAPIPathSummary> openAPISummaryList, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog) {
        boolean tagFilteringEnabled = tags.size() > 0;
        boolean operationFilteringEnabled = operations.size() > 0;
        for (ResourceSummary resourceSummary : resourceSummaryList) {
            OpenAPIPathSummary openAPIPathSummary = ValidatorUtil.getOpenApiSummaryByPath(resourceSummary.getPath(), openAPISummaryList);
            if (openAPIPathSummary == null) {
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, resourceSummary.getPathPosition(), (CharSequence)("Mismatch with OpenAPI contract. Path: " + resourceSummary.getPath()));
                continue;
            }
            ArrayList<String> unmatchedMethods = new ArrayList<String>();
            if (operationFilteringEnabled || tagFilteringEnabled) continue;
            for (String resourceMethod : resourceSummary.getMethods()) {
                boolean noMatch = true;
                for (String method : openAPIPathSummary.getAvailableOperations()) {
                    if (!method.equals(resourceMethod)) continue;
                    noMatch = false;
                    break;
                }
                if (noMatch) {
                    unmatchedMethods.add(resourceMethod);
                }
                List<OpenAPIParameter> operationParamNames = openAPIPathSummary.getParamNamesForOperation(resourceMethod);
                List<ResourceParameter> resourceParamNames = resourceSummary.getParamNames();
                for (ResourceParameter parameter : resourceParamNames) {
                    boolean isExist = false;
                    for (OpenAPIParameter openAPIParameter : operationParamNames) {
                        if (parameter.getName().equals(resourceSummary.getBody())) {
                            isExist = true;
                            continue;
                        }
                        if (openAPIParameter.isTypeAvailableAsRef()) {
                            if (!parameter.getName().equals(openAPIParameter.getName())) continue;
                            isExist = true;
                            Schema schema = openAPIComponentSummary.getSchema(openAPIParameter.getLocalRef());
                            if (schema == null) continue;
                            isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(parameter.getParameter().symbol, schema, dLog, resourceMethod);
                            continue;
                        }
                        if (!openAPIParameter.getName().equals(parameter.getName())) continue;
                        isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(parameter.getParameter().symbol, openAPIParameter.getParameter().getSchema(), dLog, resourceMethod);
                    }
                    if (isExist) continue;
                    dLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)parameter.getParameter().getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Couldn't find documentation for the parameter '" + parameter.getName() + "' for the method '" + resourceMethod + "' of the Path: " + resourceSummary.getPath()));
                }
            }
            String methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
            if (openAPIPathSummary.getAvailableOperations().containsAll(resourceSummary.getMethods())) continue;
            dLog.logDiagnostic(Diagnostic.Kind.ERROR, resourceSummary.getMethodsPosition(), (CharSequence)("Mismatch with OpenAPI contract. Couldn't find documentation for http method(s) '" + methods + "' for the Path: " + resourceSummary.getPath()));
        }
    }

    static void validateOpenApiAgainstResources(ServiceNode serviceNode, List<String> tags, List<String> operations, List<ResourceSummary> resourceSummaryList, List<OpenAPIPathSummary> openAPISummaryList, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog) {
        boolean tagFilteringEnabled = tags.size() > 0;
        boolean operationFilteringEnabled = operations.size() > 0;
        for (OpenAPIPathSummary openApiSummary : openAPISummaryList) {
            Object methods;
            List<ResourceSummary> resourceSummaries = ValidatorUtil.getResourceSummaryByPath(openApiSummary.getPath(), resourceSummaryList);
            if (resourceSummaries == null) {
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for the path: " + openApiSummary.getPath()));
                continue;
            }
            List<String> allAvailableResourceMethods = ValidatorUtil.getAllMethodsInResourceSummaries(resourceSummaries);
            ArrayList<String> unmatchedMethods = new ArrayList<String>();
            if (operationFilteringEnabled) {
                if (tagFilteringEnabled) {
                    for (String method : openApiSummary.getAvailableOperations()) {
                        if (!operations.contains(method) || !openApiSummary.hasTags(tags, method)) continue;
                        ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode);
                    }
                    if (unmatchedMethods.size() <= 0) continue;
                    methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
                    dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for http method(s) '" + (String)methods + "' for the path: " + openApiSummary.getPath()));
                    continue;
                }
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (!operations.contains(method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode);
                }
                if (unmatchedMethods.size() <= 0) continue;
                methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for http method(s) '" + (String)methods + "' for the path: " + openApiSummary.getPath()));
                continue;
            }
            if (tagFilteringEnabled) {
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (!openApiSummary.hasTags(tags, method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode);
                }
                if (unmatchedMethods.size() <= 0) continue;
                methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for http method(s) '" + (String)methods + "' for the path: " + openApiSummary.getPath()));
                continue;
            }
            for (String method : openApiSummary.getAvailableOperations()) {
                ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode);
            }
            methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
            if (allAvailableResourceMethods.containsAll(openApiSummary.getAvailableOperations())) continue;
            dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for http method(s) '" + (String)methods + "' for the path: " + openApiSummary.getPath()));
        }
    }

    private static String getUnmatchedMethodList(List<String> unmatchedMethods) {
        StringBuilder methods = new StringBuilder();
        for (int i = 0; i < unmatchedMethods.size(); ++i) {
            if (i == 0) {
                methods.append(unmatchedMethods.get(i));
                continue;
            }
            methods.append(", ").append(unmatchedMethods.get(i));
        }
        return methods.toString();
    }

    private static OpenAPIPathSummary getOpenApiSummaryByPath(String path, List<OpenAPIPathSummary> openAPISummaryList) {
        OpenAPIPathSummary openAPISummary = null;
        for (OpenAPIPathSummary openAPI : openAPISummaryList) {
            if (!openAPI.getPath().equals(path)) continue;
            openAPISummary = openAPI;
            break;
        }
        return openAPISummary;
    }

    private static void validateOperationForOpenAPI(List<String> unmatchedMethods, List<String> allAvailableResourceMethods, List<ResourceSummary> resourceSummaries, String method, OpenAPIPathSummary openApiSummary, DiagnosticLog dLog, OpenAPIComponentSummary openApiComponentSummary, ServiceNode serviceNode) {
        boolean noMatch = true;
        for (String resourceMethod : allAvailableResourceMethods) {
            if (!resourceMethod.equals(method)) continue;
            noMatch = false;
            break;
        }
        if (noMatch) {
            unmatchedMethods.add(method);
        }
        ValidatorUtil.checkForParameterMismatch(openApiSummary, resourceSummaries, method, serviceNode, openApiComponentSummary, dLog);
    }

    private static void checkForParameterMismatch(OpenAPIPathSummary openApiSummary, List<ResourceSummary> resourceSummaries, String method, ServiceNode serviceNode, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog) {
        List<OpenAPIParameter> operationParamNames = openApiSummary.getParamNamesForOperation(method);
        ResourceSummary resourceSummaryForMethod = ValidatorUtil.getResourceSummaryByMethod(resourceSummaries, method);
        if (resourceSummaryForMethod != null) {
            List<ResourceParameter> resourceParamNames = resourceSummaryForMethod.getParamNames();
            for (OpenAPIParameter openAPIParameter : operationParamNames) {
                boolean isExist = false;
                for (ResourceParameter parameter : resourceParamNames) {
                    if (openAPIParameter.isTypeAvailableAsRef()) {
                        if (!openAPIParameter.getName().equals(parameter.getName())) continue;
                        isExist = true;
                        Schema schema = openAPIComponentSummary.getSchema(openAPIParameter.getLocalRef());
                        if (schema == null) continue;
                        isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(parameter, parameter.getParameter().symbol, schema, dLog, method);
                        continue;
                    }
                    if (!openAPIParameter.getName().equals(parameter.getName())) continue;
                    isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(parameter, parameter.getParameter().symbol, openAPIParameter.getParameter().getSchema(), dLog, method);
                }
                if (isExist) continue;
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Mismatch with OpenAPI contract. Implementation is missing for parameter '" + openAPIParameter.getName() + "' for the method '" + method + "' of the Path: " + resourceSummaryForMethod.getPath()));
            }
        }
    }

    private static boolean validateResourceAgainstOpenAPIParams(BVarSymbol resourceParameterType, Schema openAPIParam, DiagnosticLog dLog, String method) {
        BType resourceParamType = resourceParameterType.getType();
        if (resourceParamType.getKind().typeName().equals("record") && resourceParamType instanceof BRecordType && openAPIParam instanceof ObjectSchema) {
            Map<String, Schema> properties = ((ObjectSchema)openAPIParam).getProperties();
            BRecordType recordType = (BRecordType)resourceParamType;
            for (BField field : recordType.fields) {
                boolean isExist = false;
                for (Map.Entry<String, Schema> entry : properties.entrySet()) {
                    if (!entry.getKey().equals(field.name.getValue()) || !field.getType().getKind().typeName().equals(ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()))) continue;
                    isExist = true;
                    if (!ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()).equals("record")) continue;
                    isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(field.symbol, entry.getValue(), dLog, method);
                }
                if (isExist) continue;
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)field.pos, (CharSequence)("Mismatch with OpenAPI contract. Couldn't find documentation for the field '" + field.name.getValue() + "' for '" + method + "' method"));
            }
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("[]") && openAPIParam.getType().equals("array")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("string") && openAPIParam.getType().equals("string")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("int") && openAPIParam.getType().equals("integer")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("boolean") && openAPIParam.getType().equals("boolean")) {
            return true;
        }
        return resourceParamType.getKind().typeName().equals("decimal") && openAPIParam.getType().equals("number");
    }

    private static boolean validateOpenAPIAgainResourceParams(ResourceParameter resourceParam, BVarSymbol resourceParameterType, Schema openAPIParam, DiagnosticLog dLog, String operation) {
        BType resourceParamType = resourceParameterType.getType();
        if (resourceParamType.getKind().typeName().equals("record") && resourceParamType instanceof BRecordType && openAPIParam instanceof ObjectSchema) {
            Map<String, Schema> properties = ((ObjectSchema)openAPIParam).getProperties();
            BRecordType recordType = (BRecordType)resourceParamType;
            for (Map.Entry<String, Schema> entry : properties.entrySet()) {
                boolean isExist = false;
                for (BField field : recordType.fields) {
                    if (!entry.getKey().equals(field.name.getValue()) || !field.getType().getKind().typeName().equals(ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()))) continue;
                    isExist = true;
                    if (!ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()).equals("record")) continue;
                    isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(resourceParam, field.symbol, entry.getValue(), dLog, operation);
                }
                if (isExist) continue;
                dLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceParam.getParameter().getPosition(), (CharSequence)("Mismatch with OpenAPI contract. No implementation found for the field '" + entry.getKey() + "' for '" + operation + "' operation."));
            }
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("[]") && openAPIParam.getType().equals("array")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("string") && openAPIParam.getType().equals("string")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("int") && openAPIParam.getType().equals("integer")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("boolean") && openAPIParam.getType().equals("boolean")) {
            return true;
        }
        return resourceParamType.getKind().typeName().equals("decimal") && openAPIParam.getType().equals("number");
    }

    private static ResourceSummary getResourceSummaryByMethod(List<ResourceSummary> resourceSummaries, String method) {
        ResourceSummary matchingResource = null;
        for (ResourceSummary resourceSummary : resourceSummaries) {
            if (!resourceSummary.isMethodAvailable(method)) continue;
            matchingResource = resourceSummary;
            break;
        }
        return matchingResource;
    }

    private static List<String> getAllMethodsInResourceSummaries(List<ResourceSummary> resourceSummaries) {
        ArrayList<String> methods = new ArrayList<String>();
        for (ResourceSummary resourceSummary : resourceSummaries) {
            methods.addAll(resourceSummary.getMethods());
        }
        return methods;
    }

    private static List<ResourceSummary> getResourceSummaryByPath(String path, List<ResourceSummary> resourceSummaryList) {
        ArrayList<ResourceSummary> resourceSummaries = null;
        for (ResourceSummary resourceSummary : resourceSummaryList) {
            if (!resourceSummary.getPath().equals(path)) continue;
            if (resourceSummaries == null) {
                resourceSummaries = new ArrayList<ResourceSummary>();
                resourceSummaries.add(resourceSummary);
                continue;
            }
            resourceSummaries.add(resourceSummary);
        }
        return resourceSummaries;
    }

    private static String convertOpenAPITypeToBallerina(String type) {
        String convertedType;
        switch (type) {
            case "integer": {
                convertedType = "int";
                break;
            }
            case "string": {
                convertedType = "string";
                break;
            }
            case "boolean": {
                convertedType = "boolean";
                break;
            }
            case "array": {
                convertedType = "[]";
                break;
            }
            case "object": {
                convertedType = "record";
                break;
            }
            case "number": {
                convertedType = "decimal";
                break;
            }
            default: {
                convertedType = "";
            }
        }
        return convertedType;
    }
}

