/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.cmd;

import com.google.protobuf.DescriptorProtos;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.exception.BalGenToolException;
import org.ballerinalang.protobuf.utils.BalFileGenerationUtils;
import org.ballerinalang.protobuf.utils.ProtocCommandBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorsGenerator.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<byte[]> generatedependentDescriptor(String parentDescPath, String parentProtoPath, List<byte[]> list, String exePath, ClassLoader classLoader) {
        File initialFile = new File(parentDescPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet descSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            for (String depPath : descSet.getFile(0).getDependencyList()) {
                Throwable throwable;
                String protoPath;
                String path = "desc_gen/dependencies" + depPath.substring(depPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR), depPath.length()).replace(".proto", "") + ".desc";
                BalFileGenerationUtils.createMetaFolder(path);
                if (!depPath.contains("google/protobuf")) {
                    protoPath = new File(new File(BalFileGenerationUtils.resolveProtoFloderPath(parentProtoPath)).toURI().getPath() + depPath).toURI().getPath();
                } else {
                    File dependentDesc = new File("desc_gen/" + depPath);
                    File parentFile = dependentDesc.getParentFile();
                    if (!parentFile.exists() && !parentFile.mkdirs()) {
                        throw new IllegalStateException("Couldn't create directory 'desc_gen/" + depPath + "'");
                    }
                    try {
                        throwable = null;
                        try (InputStream initialStream = classLoader.getResourceAsStream(depPath);
                             FileOutputStream outStream2 = new FileOutputStream(dependentDesc);){
                            byte[] buffer = new byte[initialStream.available()];
                            int read = initialStream.read(buffer);
                            if (read == -1) {
                                throw new IllegalStateException("Couldn't read input stream of 'google/protobuf' resource: ");
                            }
                            ((OutputStream)outStream2).write(buffer);
                            ((OutputStream)outStream2).close();
                            protoPath = dependentDesc.getAbsolutePath();
                        }
                        catch (Throwable outStream2) {
                            throwable = outStream2;
                            throw outStream2;
                        }
                    }
                    catch (IOException e) {
                        throw new BalGenToolException("Error reading resource file '" + depPath + "'", e);
                    }
                }
                String command = new ProtocCommandBuilder(exePath, protoPath, BalFileGenerationUtils.resolveProtoFloderPath(protoPath), new File(BalFileGenerationUtils.getDescriptorPath(depPath)).getAbsolutePath()).build();
                BalFileGenerationUtils.generateDescriptor(command);
                File childFile = new File(path);
                try {
                    FileInputStream childStream = new FileInputStream(childFile);
                    throwable = null;
                    try {
                        DescriptorProtos.FileDescriptorSet childDescSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)childStream);
                        if (childDescSet.getFile(0).getDependencyCount() != 0) {
                            ArrayList<byte[]> newList = new ArrayList<byte[]>();
                            DescriptorsGenerator.generatedependentDescriptor(path, protoPath, newList, exePath, classLoader);
                            continue;
                        }
                        initialFile = new File(path);
                        try {
                            FileInputStream dependentStream = new FileInputStream(initialFile);
                            Throwable throwable2 = null;
                            try {
                                DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)dependentStream);
                                list.add(set.getFile(0).toByteArray());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (dependentStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((InputStream)dependentStream).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((InputStream)dependentStream).close();
                            }
                        }
                        catch (IOException e) {
                            throw new BalGenToolException("Error reading dependent descriptor.", e);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (childStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)childStream).close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        ((InputStream)childStream).close();
                    }
                }
                catch (IOException e) {
                    throw new BalGenToolException("Error extracting dependent bal.", e);
                    return list;
                }
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Error parsing descriptor file " + initialFile, e);
        }
    }
}

