/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.net.grpc.builder.BallerinaFileBuilder;
import org.ballerinalang.net.grpc.exception.BalGenerationException;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.cmd.DescriptorsGenerator;
import org.ballerinalang.protobuf.cmd.OSDetector;
import org.ballerinalang.protobuf.exception.BalGenToolException;
import org.ballerinalang.protobuf.utils.BalFileGenerationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"grpc"}, commandDescription="Generates ballerina gRPC client stub for gRPC service for a given grpc protoc definition.")
public class GrpcCmd
implements BLauncherCmd {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcCmd.class);
    private static final PrintStream outStream = System.out;
    private static final PrintStream errStream = System.err;
    private JCommander parentCmdParser;
    @Parameter(names={"--input"}, description="Input .proto file", required=true)
    private String protoPath;
    @Parameter(names={"--output"}, description="Generated Ballerina source files location")
    private String balOutPath = "";
    private String exePath;
    private String protocVersion = "3.4.0";
    @Parameter(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @Parameter(names={"--debug"}, hidden=true)
    private String debugPort;
    @Parameter(names={"--java.debug"}, hidden=true, description="remote java debugging port")
    private String javaDebugPort;

    public void execute() {
        File protoFile = new File(this.protoPath);
        if (!protoFile.isFile() || !protoFile.exists() || "".equals(this.protoPath) || !this.protoPath.contains(".proto")) {
            String errorMessage = "Invalid proto file location. Please input valid proto file location.";
            errStream.println(errorMessage);
            throw new BalGenToolException(errorMessage);
        }
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"build");
            outStream.println(commandUsageInfo);
            return;
        }
        try {
            this.downloadProtocexe();
        }
        catch (BalGenToolException e) {
            LOG.error("Error while generating protoc executable. ", (Throwable)e);
            throw new BalGenToolException("Error while generating protoc executable. ", e);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        String descriptorPath = "desc_gen/" + this.getProtoFileName() + "-descriptor.desc";
        File descFile = this.generateDescTempFolder(descriptorPath);
        StringBuilder msg = new StringBuilder();
        LOG.debug("Initializing the ballerina code generation.");
        List<String> protoFiles = this.readProperties(classLoader);
        for (String file : protoFiles) {
            try {
                GrpcCmd.exportResource(file, classLoader);
            }
            catch (Exception e) {
                msg.append("Error extracting resource file ").append(file).append(BalGenerationConstants.NEW_LINE_CHARACTER);
                outStream.println(msg.toString());
                LOG.error("Error exacting resource file " + file, (Throwable)e);
            }
        }
        msg.append("Successfully generated initial files.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
        byte[] root = BalFileGenerationUtils.getProtoByteArray(this.exePath, this.protoPath, descFile.getAbsolutePath());
        LOG.debug("Successfully generated root descriptor.");
        List<byte[]> dependant = DescriptorsGenerator.generatedependentDescriptor(descriptorPath, this.protoPath, new ArrayList<byte[]>(), this.exePath, classLoader);
        LOG.debug("Successfully generated dependent descriptor.");
        try {
            BallerinaFileBuilder ballerinaFileBuilder = "".equals(this.balOutPath) ? new BallerinaFileBuilder(dependant) : new BallerinaFileBuilder(dependant, this.balOutPath);
            ballerinaFileBuilder.setRootDescriptor(root);
            ballerinaFileBuilder.build();
        }
        catch (BalGenerationException e) {
            LOG.error("Error generating ballerina file.", (Throwable)e);
            msg.append("Error generating ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
            outStream.println(msg.toString());
        }
        msg.append("Successfully generated ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
        BalFileGenerationUtils.delete(new File("desc_gen"));
        BalFileGenerationUtils.delete(new File("google"));
        LOG.debug("Successfully deleted temporary files.");
        outStream.println(msg.toString());
    }

    private File generateDescTempFolder(String descriptorPath) {
        File descFile = new File(descriptorPath);
        String path = descFile.getAbsolutePath().substring(0, descFile.getAbsolutePath().lastIndexOf(BalGenerationConstants.FILE_SEPARATOR));
        File folderPath = new File(path);
        try {
            if (!folderPath.exists() && !folderPath.mkdirs()) {
                throw new IllegalStateException("Couldn't create dir: " + descFile);
            }
            descriptorPath = descFile.getAbsolutePath();
            byte[] data = new byte[]{};
            Path file = Paths.get(descriptorPath, new String[0]);
            Files.write(file, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BalGenToolException("Error creating " + descriptorPath + " file.", e);
        }
        File targetFile = new File("google/protobuf/compiler/plugin.proto");
        File parent1 = targetFile.getParentFile();
        File parent2 = targetFile.getParentFile().getParentFile();
        File parent3 = targetFile.getParentFile().getParentFile().getParentFile();
        if (!parent1.exists() && !parent1.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent1);
        }
        if (!parent2.exists() && !parent2.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent2);
        }
        if (!parent3.exists() && !parent3.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent3);
        }
        return descFile;
    }

    private static void exportResource(String resourceName, ClassLoader classLoader) {
        try (InputStream initialStream = classLoader.getResourceAsStream(resourceName);
             FileOutputStream resStreamOut = new FileOutputStream(resourceName.replace("stdlib", "protobuf"));){
            int readBytes;
            if (initialStream == null) {
                throw new BalGenToolException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            while ((readBytes = initialStream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Cannot find '" + resourceName + "' resource  at the jar.", e);
        }
    }

    private void downloadProtocexe() {
        if (this.exePath == null) {
            this.exePath = "protoc-" + OSDetector.getDetectedClassifier() + ".exe";
            File exeFile = new File(this.exePath);
            this.exePath = exeFile.getAbsolutePath();
            if (!exeFile.isFile()) {
                outStream.println("Downloading proc executor ...");
                try {
                    boolean newFile = exeFile.createNewFile();
                    if (newFile) {
                        LOG.debug("Successfully created new protoc exe file" + this.exePath);
                    }
                }
                catch (IOException e) {
                    throw new BalGenToolException("Exception occurred while creating new file for protoc exe. ", e);
                }
                String url = "http://repo1.maven.org/maven2/com/google/protobuf/protoc/" + this.protocVersion + "/" + "protoc-" + this.protocVersion + "-" + OSDetector.getDetectedClassifier() + ".exe";
                try {
                    BalFileGenerationUtils.saveFile(new URL(url), this.exePath);
                    File file = new File(this.exePath);
                    BalFileGenerationUtils.grantPermission(file);
                }
                catch (IOException e) {
                    throw new BalGenToolException("Exception occurred while writing protoc executable to file. ", e);
                }
                outStream.println("Download successfully completed!");
            } else {
                BalFileGenerationUtils.grantPermission(exeFile);
                outStream.println("Continue with existing protoc executor.");
            }
        } else {
            outStream.println("Pre-Downloaded descriptor detected ...");
        }
    }

    public String getName() {
        return "grpc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates ballerina grRPC client stub for gRPC service").append(System.lineSeparator());
        out.append("for a given grpc protoc definition").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina grpc --input chat.proto\n");
    }

    private String getProtoFileName() {
        String[] arr = this.protoPath.split(BalGenerationConstants.FILE_SEPARATOR);
        return arr[arr.length - 1].replace(".proto", "");
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }

    private List<String> readProperties(ClassLoader classLoader) {
        ArrayList<String> protoFilesList = new ArrayList<String>();
        try (InputStream initialStream = classLoader.getResourceAsStream("standardProtos.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(initialStream, StandardCharsets.UTF_8));){
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                protoFilesList.add(fileName);
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Error in reading standardProtos.properties.", e);
        }
        return protoFilesList;
    }

    public void setProtoPath(String protoPath) {
        this.protoPath = protoPath;
    }

    public void setBalOutPath(String balOutPath) {
        this.balOutPath = balOutPath;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public void setProtocVersion(String protocVersion) {
        this.protocVersion = protocVersion;
    }
}

