/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.utils;

import com.google.protobuf.DescriptorProtos;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.exception.BalGenToolException;
import org.ballerinalang.protobuf.utils.ProtocCommandBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalFileGenerationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BalFileGenerationUtils.class);

    public static void createMetaFolder(String folderPath) {
        boolean isFileCreated = new File(folderPath).getParentFile().mkdirs();
        if (!isFileCreated) {
            LOG.debug("Meta folder did not create successfully '" + folderPath + "'");
        }
        byte[] dataBytes = new byte[]{};
        try {
            Path file = Paths.get(folderPath, new String[0]);
            Files.write(file, dataBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BalGenToolException("Error creating .desc meta files.", e);
        }
    }

    public static void generateDescriptor(String command) {
        Process process;
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (isWindows) {
            builder.command("cmd.exe", "/c", "dir");
        } else {
            builder.command("sh", "-c", command);
        }
        builder.directory(new File(System.getProperty("user.home")));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new BalGenToolException("Error in executing protoc command '" + command + "'.", e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new BalGenToolException("Process not successfully completed. Process is interrupted while running the protoC executor.", e);
        }
    }

    public static String getDescriptorPath(String protoPath) {
        return "desc_gen/dependencies" + protoPath.substring(protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR), protoPath.length()).replace(".proto", "") + ".desc";
    }

    public static String resolveProtoFloderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR);
        String protofolderPath = "";
        if (idx > 0) {
            protofolderPath = protoPath.substring(0, idx);
        }
        return protofolderPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getProtoByteArray(String exePath, String protoPath, String descriptorPath) {
        String command = new ProtocCommandBuilder(exePath, protoPath, BalFileGenerationUtils.resolveProtoFloderPath(protoPath), descriptorPath).build();
        BalFileGenerationUtils.generateDescriptor(command);
        File initialFile = new File(descriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            if (set.getFileList().size() <= 0) return new byte[0];
            byte[] byArray = set.getFile(0).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BalGenToolException("Error reading generated descriptor file '" + descriptorPath + "'.", e);
        }
    }

    public static void delete(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            String[] files = file.list();
            if (files != null && files.length != 0) {
                for (String temp : files) {
                    File fileDelete = new File(file, temp);
                    if (fileDelete.isDirectory()) {
                        BalFileGenerationUtils.delete(fileDelete);
                    }
                    if (!fileDelete.delete()) continue;
                    LOG.debug("Successfully deleted file " + file.toString());
                }
            }
            if (file.delete()) {
                LOG.debug("Successfully deleted file " + file.toString());
            }
            if (file.getParentFile() != null && file.getParentFile().delete()) {
                LOG.debug("Successfully deleted parent file " + file.toString());
            }
        } else if (file != null && file.delete()) {
            LOG.debug("Successfully deleted parent file " + file.toString());
        }
    }

    public static void saveFile(URL url, String file) {
        try (InputStream in = url.openStream();
             FileOutputStream fos = new FileOutputStream(new File(file));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > -1) {
                fos.write(buffer, 0, length);
            }
            fos.close();
            in.close();
        }
        catch (IOException e) {
            throw new BalGenToolException("Error saving file '" + file + "'.", e);
        }
    }

    public static void grantPermission(File file) {
        boolean isExecutable = file.setExecutable(true);
        boolean isReadable = file.setReadable(true);
        boolean isWritable = file.setWritable(true);
        if (isExecutable && isReadable && isWritable) {
            LOG.debug("Successfully grated permission for protoc exe file");
        } else {
            LOG.debug("Failed to prowide execute permission to protoc executor.");
        }
    }
}

