/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.net.grpc.builder.BallerinaFileBuilder;
import org.ballerinalang.net.grpc.exception.CodeBuilderException;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.cmd.DescriptorsGenerator;
import org.ballerinalang.protobuf.cmd.OSDetector;
import org.ballerinalang.protobuf.exception.CodeGeneratorException;
import org.ballerinalang.protobuf.utils.BalFileGenerationUtils;
import org.ballerinalang.tool.BLauncherCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="grpc", description={"generate Ballerina gRPC client stub for gRPC service for a given gRPC protoc definition."})
public class GrpcCmd
implements BLauncherCmd {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcCmd.class);
    private static final PrintStream outStream = System.out;
    private static final String PROTO_EXTENSION = "proto";
    private static final String WHITESPACE_CHARACTOR = " ";
    private static final String WHITESPACE_REPLACEMENT = "\\ ";
    private CommandLine parentCmdParser;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--input"}, description={"Input .proto file"})
    private String protoPath;
    @CommandLine.Option(names={"--mode"}, description={"Ballerina source [service or client]"})
    private String mode = "stub";
    @CommandLine.Option(names={"--output"}, description={"Generated Ballerina source files location"})
    private String balOutPath;
    private String protocExePath;
    @CommandLine.Option(names={"--protocVersion"}, hidden=true)
    private String protocVersion = "3.21.7";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Set<byte[]> dependant;
        byte[] root;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            outStream.println(commandUsageInfo);
            return;
        }
        Optional<String> pathExtension = this.getFileExtension(this.protoPath);
        if (!pathExtension.isPresent() || !PROTO_EXTENSION.equalsIgnoreCase(pathExtension.get())) {
            String errorMessage = "Invalid proto file path. Please input valid proto file location.";
            outStream.println(errorMessage);
            return;
        }
        if (!Files.isReadable(Paths.get(this.protoPath, new String[0]))) {
            String errorMessage = "Provided service proto file is not readable. Please input valid proto file location.";
            outStream.println(errorMessage);
            return;
        }
        try {
            this.downloadProtocexe();
        }
        catch (IOException | CodeGeneratorException e) {
            String errorMessage = "Error while generating protoc executable. " + e.getMessage();
            LOG.error("Error while generating protoc executable.", (Throwable)e);
            outStream.println(errorMessage);
            return;
        }
        File descFile = this.createTempDirectory();
        StringBuilder msg = new StringBuilder();
        LOG.debug("Initializing the ballerina code generation.");
        try {
            File tempDir;
            String errorMessage;
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                List<String> protoFiles = this.readProperties(classLoader);
                for (String file : protoFiles) {
                    GrpcCmd.exportResource(file, classLoader);
                }
            }
            catch (Exception e) {
                LOG.error("Error extracting resource file ", (Throwable)e);
                outStream.println("Error while reading proto library files. " + e.getMessage());
                File tempDir2 = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete(new File(tempDir2, "desc_gen"));
                BalFileGenerationUtils.delete(new File(tempDir2, "google"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            if (!msg.toString().isEmpty()) {
                outStream.println(msg.toString());
                return;
            }
            outStream.println("Successfully extracted library files.");
            try {
                root = DescriptorsGenerator.generateRootDescriptor(this.protocExePath, this.escapeSpaceCharacter(this.protoPath), descFile.getAbsolutePath());
            }
            catch (CodeGeneratorException e) {
                errorMessage = "Error occurred when generating proto descriptor. " + e.getMessage();
                LOG.error("Error occurred when generating proto descriptor.", (Throwable)e);
                outStream.println(errorMessage);
                tempDir = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete(new File(tempDir, "desc_gen"));
                BalFileGenerationUtils.delete(new File(tempDir, "google"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            if (root.length == 0) {
                String errorMsg = "Error occurred when generating proto descriptor.";
                LOG.error(errorMsg);
                outStream.println(errorMsg);
                return;
            }
            LOG.debug("Successfully generated root descriptor.");
            try {
                dependant = DescriptorsGenerator.generateDependentDescriptor(this.protocExePath, this.escapeSpaceCharacter(this.protoPath), descFile.getAbsolutePath());
            }
            catch (CodeGeneratorException e) {
                errorMessage = "Error occurred when generating dependent proto descriptor. " + e.getMessage();
                LOG.error(errorMessage, (Throwable)e);
                outStream.println(errorMessage);
                tempDir = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete(new File(tempDir, "desc_gen"));
                BalFileGenerationUtils.delete(new File(tempDir, "google"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            LOG.debug("Successfully generated dependent descriptor.");
        }
        finally {
            File tempDir = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
            BalFileGenerationUtils.delete(new File(tempDir, "desc_gen"));
            BalFileGenerationUtils.delete(new File(tempDir, "google"));
            LOG.debug("Successfully deleted temporary files.");
        }
        BallerinaFileBuilder ballerinaFileBuilder = this.balOutPath == null ? new BallerinaFileBuilder(root, dependant) : new BallerinaFileBuilder(root, dependant, this.balOutPath);
        try {
            ballerinaFileBuilder.build(this.mode);
        }
        catch (CodeBuilderException e) {
            LOG.error("Error generating ballerina file.", (Throwable)e);
            msg.append("Error generating ballerina file.").append(e.getMessage()).append(BalGenerationConstants.NEW_LINE_CHARACTER);
            outStream.println(msg.toString());
            return;
        }
        msg.append("Successfully generated ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
        outStream.println(msg.toString());
    }

    private File createTempDirectory() {
        File parent = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
        File metadataHome = new File(parent, "desc_gen");
        if (!metadataHome.exists() && !metadataHome.mkdir()) {
            throw new IllegalStateException("Couldn't create dir: " + metadataHome);
        }
        File googleHome = new File(parent, "google");
        this.createTempDirectory(googleHome);
        File protobufHome = new File(googleHome, "protobuf");
        this.createTempDirectory(protobufHome);
        File compilerHome = new File(protobufHome, "compiler");
        this.createTempDirectory(compilerHome);
        return new File(metadataHome, this.getProtoFileName() + "-descriptor.desc");
    }

    private void createTempDirectory(File dirName) {
        if (!dirName.exists() && !dirName.mkdir()) {
            throw new IllegalStateException("Couldn't create dir: " + dirName);
        }
    }

    private Optional<String> getFileExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    private String escapeSpaceCharacter(String protoPath) {
        return Paths.get(protoPath.replace(WHITESPACE_CHARACTOR, WHITESPACE_REPLACEMENT), new String[0]).toAbsolutePath().toString();
    }

    private static void exportResource(String resourceName, ClassLoader classLoader) throws CodeGeneratorException {
        try (InputStream initialStream = classLoader.getResourceAsStream(resourceName);
             FileOutputStream resStreamOut = new FileOutputStream(new File(ServiceProtoConstants.TMP_DIRECTORY_PATH, resourceName.replace("stdlib", "protobuf")));){
            int readBytes;
            if (initialStream == null) {
                throw new CodeGeneratorException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            while ((readBytes = initialStream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Cannot find '" + resourceName + "' resource  at the jar.", e);
        }
    }

    private void downloadProtocexe() throws IOException, CodeGeneratorException {
        if (this.protocExePath == null) {
            String protocFilename = "protoc-" + OSDetector.getDetectedClassifier() + ".exe";
            File protocExeFile = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH, protocFilename);
            this.protocExePath = protocExeFile.getAbsolutePath();
            if (!protocExeFile.exists()) {
                outStream.println("Downloading protoc executor file - " + protocFilename);
                String protocDownloadurl = "https://repo1.maven.org/maven2/com/google/protobuf/protoc/" + this.protocVersion + "/protoc-" + this.protocVersion + "-" + OSDetector.getDetectedClassifier() + ".exe";
                File tempDownloadFile = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH, "protoc-" + OSDetector.getDetectedClassifier() + ".exe.download");
                try {
                    BalFileGenerationUtils.downloadFile(new URL(protocDownloadurl), tempDownloadFile);
                    Files.move(tempDownloadFile.toPath(), protocExeFile.toPath(), new CopyOption[0]);
                    BalFileGenerationUtils.grantPermission(protocExeFile);
                }
                catch (CodeGeneratorException e) {
                    Files.deleteIfExists(Paths.get(this.protocExePath, new String[0]));
                    throw e;
                }
                outStream.println("Download successfully completed. Executor file path - " + protocExeFile.getPath());
            } else {
                BalFileGenerationUtils.grantPermission(protocExeFile);
                outStream.println("Continue with existing protoc executor file at " + protocExeFile.getPath());
            }
        } else {
            outStream.println("Continue with provided protoc executor file at " + this.protocExePath);
        }
    }

    public String getName() {
        return "grpc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates ballerina gRPC client stub for gRPC service").append(System.lineSeparator());
        out.append("for a given grpc protoc definition").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina grpc --input chat.proto\n");
    }

    private String getProtoFileName() {
        File file = new File(this.protoPath);
        return file.getName().replace(".proto", "");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    private List<String> readProperties(ClassLoader classLoader) throws CodeGeneratorException {
        ArrayList<String> protoFilesList = new ArrayList<String>();
        try (InputStream initialStream = classLoader.getResourceAsStream("standardProtos.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(initialStream, StandardCharsets.UTF_8));){
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                protoFilesList.add(fileName);
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while reading property file.", e);
        }
        return protoFilesList;
    }

    public void setProtoPath(String protoPath) {
        this.protoPath = protoPath;
    }

    public void setBalOutPath(String balOutPath) {
        this.balOutPath = balOutPath;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

