/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.siddhi.annotation.processor;

import java.text.MessageFormat;
import org.ballerinalang.siddhi.annotation.Parameter;
import org.ballerinalang.siddhi.annotation.ReturnAttribute;
import org.ballerinalang.siddhi.annotation.processor.AbstractAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.util.AnnotationValidationException;

public class AggregationAttributeValidationAnnotationProcessor
extends AbstractAnnotationProcessor {
    public AggregationAttributeValidationAnnotationProcessor(String extensionClassFullName) {
        super(extensionClassFullName);
    }

    @Override
    public void parameterValidation(Parameter[] parameters) throws AnnotationValidationException {
        for (Parameter parameter : parameters) {
            String parameterName = parameter.name();
            if (parameterName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!PARAMETER_NAME_PATTERN.matcher(parameterName).find()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} annotated in class {1} is not in proper format ''abc.def.ghi''.", parameterName, this.extensionClassFullName));
            }
            if (parameter.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> description annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> type annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (!parameter.dynamic()) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> dynamic property cannot be true annotated in class {1}.", parameterName, this.extensionClassFullName));
        }
    }

    @Override
    public void returnAttributesValidation(ReturnAttribute[] returnAttributes) throws AnnotationValidationException {
        if (returnAttributes.length == 0) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (returnAttributes.length == 1) {
            String returnAttributeName = returnAttributes[0].name();
            if (!returnAttributeName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name cannot be annotated in class {1}.", this.extensionClassFullName));
            }
            if (returnAttributes[0].description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name:{0} -> description annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
            }
            if (returnAttributes[0].type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name{0} -> type annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
            }
        } else {
            throw new AnnotationValidationException(MessageFormat.format("Only one @Extension -> @ReturnAttribute can be annotated in class {0}.", this.extensionClassFullName));
        }
    }
}

