/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.siddhi.annotation.processor;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.ballerinalang.siddhi.annotation.Example;
import org.ballerinalang.siddhi.annotation.Extension;
import org.ballerinalang.siddhi.annotation.Parameter;
import org.ballerinalang.siddhi.annotation.ReturnAttribute;
import org.ballerinalang.siddhi.annotation.SystemParameter;
import org.ballerinalang.siddhi.annotation.processor.AbstractAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.AggregationAttributeValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.DistributionStrategyValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.FunctionExecutorValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.IncrementalAggregationAttributeValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.ScriptValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.SinkMapperValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.SinkValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.SourceMapperValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.SourceValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.StoreValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.StreamFunctionProcessorValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.StreamProcessorValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.processor.WindowProcessorValidationAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.util.AnnotationValidationException;

public class SiddhiAnnotationProcessor
extends AbstractProcessor {
    private final List<Class<? extends Annotation>> annotationsClasses = new ArrayList<Class<? extends Annotation>>();
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.annotationsClasses.add(Extension.class);
        this.annotationsClasses.add(Parameter.class);
        this.annotationsClasses.add(ReturnAttribute.class);
        this.annotationsClasses.add(SystemParameter.class);
        this.annotationsClasses.add(Example.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Extension.class)) {
            if (element.getKind() == ElementKind.CLASS) {
                String superClass = this.getMatchingSuperClass(element, new String[]{"org.ballerinalang.siddhi.core.stream.output.sink.SinkMapper", "org.ballerinalang.siddhi.core.stream.output.sink.Sink", "org.ballerinalang.siddhi.core.executor.function.FunctionExecutor", "org.ballerinalang.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator", "org.ballerinalang.siddhi.core.stream.output.sink.distributed.DistributionStrategy", "org.ballerinalang.siddhi.core.query.processor.stream.StreamProcessor", "org.ballerinalang.siddhi.core.query.processor.stream.function.StreamFunctionProcessor", "org.ballerinalang.siddhi.core.table.record.AbstractRecordTable", "org.ballerinalang.siddhi.core.stream.input.source.Source", "org.ballerinalang.siddhi.core.stream.input.source.SourceMapper", "org.ballerinalang.siddhi.core.query.processor.stream.window.WindowProcessor", "org.ballerinalang.siddhi.core.function.Script", "org.ballerinalang.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator"});
                AbstractAnnotationProcessor abstractAnnotationProcessor = null;
                Extension annotation = element.getAnnotation(Extension.class);
                String name = annotation.name();
                String description = annotation.description();
                String namespace = annotation.namespace();
                Parameter[] parameters = annotation.parameters();
                ReturnAttribute[] returnAttributes = annotation.returnAttributes();
                SystemParameter[] systemParameters = annotation.systemParameter();
                Example[] examples = annotation.examples();
                String extensionClassFullName = element.asType().toString();
                if (superClass != null) {
                    switch (superClass) {
                        case "org.ballerinalang.siddhi.core.stream.output.sink.distributed.DistributionStrategy": {
                            abstractAnnotationProcessor = new DistributionStrategyValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.stream.output.sink.SinkMapper": {
                            abstractAnnotationProcessor = new SinkMapperValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.stream.output.sink.Sink": {
                            abstractAnnotationProcessor = new SinkValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.executor.function.FunctionExecutor": {
                            abstractAnnotationProcessor = new FunctionExecutorValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator": {
                            abstractAnnotationProcessor = new AggregationAttributeValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.query.processor.stream.StreamProcessor": {
                            abstractAnnotationProcessor = new StreamProcessorValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.stream.input.source.Source": {
                            abstractAnnotationProcessor = new SourceValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.stream.input.source.SourceMapper": {
                            abstractAnnotationProcessor = new SourceMapperValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.table.record.AbstractRecordTable": {
                            abstractAnnotationProcessor = new StoreValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.query.processor.stream.function.StreamFunctionProcessor": {
                            abstractAnnotationProcessor = new StreamFunctionProcessorValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.query.processor.stream.window.WindowProcessor": {
                            abstractAnnotationProcessor = new WindowProcessorValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.function.Script": {
                            abstractAnnotationProcessor = new ScriptValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        case "org.ballerinalang.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator": {
                            abstractAnnotationProcessor = new IncrementalAggregationAttributeValidationAnnotationProcessor(extensionClassFullName);
                            break;
                        }
                        default: {
                            this.showBuildError(MessageFormat.format("Default switch case executed as there is no matching super class option for @{0}.", superClass), element);
                        }
                    }
                    if (abstractAnnotationProcessor != null) {
                        try {
                            abstractAnnotationProcessor.basicParameterValidation(name, description, namespace);
                            abstractAnnotationProcessor.parameterValidation(parameters);
                            abstractAnnotationProcessor.returnAttributesValidation(returnAttributes);
                            abstractAnnotationProcessor.systemParametersValidation(systemParameters);
                            abstractAnnotationProcessor.examplesValidation(examples);
                        }
                        catch (AnnotationValidationException e) {
                            this.showBuildError(e.getMessage(), element);
                        }
                        continue;
                    }
                    this.showBuildError(MessageFormat.format("Error while validation, abstractAnnotationProcessor cannot be null.", superClass), element);
                    continue;
                }
                this.showBuildError("Class does not have a matching Siddhi Extension super class.", element);
                continue;
            }
            this.showBuildError(MessageFormat.format("Only classes can be annotated with @{0}.", Extension.class.getCanonicalName()), element);
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotationTypes = new HashSet<String>();
        for (Class<? extends Annotation> annotationClass : this.annotationsClasses) {
            annotationTypes.add(annotationClass.getCanonicalName());
        }
        return annotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    private String getMatchingSuperClass(Element elementToValidate, String[] superClassNames) {
        TypeMirror superType = ((TypeElement)elementToValidate).getSuperclass();
        String superClass = null;
        while (!"none".equals(superType.toString())) {
            Element superTypeElement = ((DeclaredType)superType).asElement();
            if (Arrays.asList(superClassNames).contains(superTypeElement.toString())) {
                superClass = superTypeElement.toString();
                break;
            }
            superType = ((TypeElement)superTypeElement).getSuperclass();
        }
        return superClass;
    }

    public void showBuildError(String message, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }
}

