/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.siddhi.annotation.processor;

import java.text.MessageFormat;
import org.ballerinalang.siddhi.annotation.Parameter;
import org.ballerinalang.siddhi.annotation.ReturnAttribute;
import org.ballerinalang.siddhi.annotation.processor.AbstractAnnotationProcessor;
import org.ballerinalang.siddhi.annotation.util.AnnotationValidationException;

public class SourceValidationAnnotationProcessor
extends AbstractAnnotationProcessor {
    public SourceValidationAnnotationProcessor(String extensionClassFullName) {
        super(extensionClassFullName);
    }

    @Override
    public void basicParameterValidation(String name, String description, String namespace) throws AnnotationValidationException {
        if (name.isEmpty()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> name  annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (description.isEmpty()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> description annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (namespace.isEmpty()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> namespace cannot be null or empty, annotated class {1}  extends from namespace reserved super class {2}.", name, this.extensionClassFullName, "org.ballerinalang.siddhi.core.stream.input.source.Source"));
        }
        if (!namespace.equals("source")) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> namespace provided {0} should be corrected as {1} annotated in class {2}.", namespace, "source", this.extensionClassFullName));
        }
    }

    @Override
    public void parameterValidation(Parameter[] parameters) throws AnnotationValidationException {
        for (Parameter parameter : parameters) {
            String parameterName = parameter.name();
            if (parameterName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!PARAMETER_NAME_PATTERN.matcher(parameterName).find()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} annotated in class {1} is not in proper format ''abc.def.ghi''.", parameterName, this.extensionClassFullName));
            }
            if (parameter.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> description annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> type annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.dynamic()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> dynamic property cannot be true annotated in class {1}.", parameterName, this.extensionClassFullName));
            }
            if (!parameter.optional() || !parameter.defaultValue().isEmpty()) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> defaultValue annotated in class {1} cannot be null or empty for the optional parameter.", parameterName, this.extensionClassFullName));
        }
    }

    @Override
    public void returnAttributesValidation(ReturnAttribute[] returnAttributes) throws AnnotationValidationException {
        if (returnAttributes != null && returnAttributes.length > 0) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute cannot be annotated in class {0}.", this.extensionClassFullName));
        }
    }
}

