/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.langlib.string.utils.StringUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.string", functionName="substring", args={@Argument(name="mainString", type=TypeKind.STRING), @Argument(name="startIndex", type=TypeKind.INT), @Argument(name="endIndex", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class Substring {
    public static String substring(Strand strand, String value, long startIndex, long endIndex) {
        StringUtils.checkForNull(value);
        if (startIndex != (long)((int)startIndex)) {
            throw BLangExceptionHelper.getRuntimeException((String)BallerinaErrorReasons.STRING_OPERATION_ERROR, (RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{startIndex});
        }
        if (endIndex != (long)((int)endIndex)) {
            throw BLangExceptionHelper.getRuntimeException((String)BallerinaErrorReasons.STRING_OPERATION_ERROR, (RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{endIndex});
        }
        if (startIndex < 0L || endIndex > (long)value.length()) {
            throw BLangExceptionHelper.getRuntimeException((String)BallerinaErrorReasons.STRING_OPERATION_ERROR, (RuntimeErrors)RuntimeErrors.STRING_INDEX_OUT_OF_RANGE, (Object[])new Object[]{value.length(), startIndex, endIndex});
        }
        if (endIndex < startIndex) {
            throw BLangExceptionHelper.getRuntimeException((String)BallerinaErrorReasons.STRING_OPERATION_ERROR, (RuntimeErrors)RuntimeErrors.INVALID_SUBSTRING_RANGE, (Object[])new Object[]{value.length(), startIndex, endIndex});
        }
        return value.substring((int)startIndex, (int)endIndex);
    }
}

