/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.FastaReader;
import org.biojava3.core.sequence.io.GenericFastaHeaderFormat;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.template.FastaHeaderFormatInterface;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FastaWriter<S extends Sequence<?>, C extends Compound> {
    OutputStream os;
    Collection<S> sequences;
    FastaHeaderFormatInterface<S, C> headerFormat;
    private int lineLength = 60;

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
    }

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
    }

    public void process() throws Exception {
        byte[] lineSep = System.getProperty("line.separator").getBytes();
        for (Sequence sequence : this.sequences) {
            String header = this.headerFormat.getHeader(sequence);
            this.os.write(62);
            this.os.write(header.getBytes());
            this.os.write(lineSep);
            int compoundCount = 0;
            String seq = "";
            seq = sequence.getSequenceAsString();
            for (int i = 0; i < seq.length(); ++i) {
                this.os.write(seq.charAt(i));
                if (++compoundCount != this.lineLength) continue;
                this.os.write(lineSep);
                compoundCount = 0;
            }
            if (sequence.getLength() % this.getLineLength() == 0) continue;
            this.os.write(lineSep);
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("test.fasta");
            FastaReader fastaReader = new FastaReader(is, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            is.close();
            System.out.println(proteinSequences);
            FileOutputStream fileOutputStream = new FileOutputStream("test_out.fasta");
            FastaWriter fastaWriter = new FastaWriter(fileOutputStream, proteinSequences.values(), new GenericFastaHeaderFormat());
            fastaWriter.process();
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

