/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.api.EJB2ServerAPI;
import org.bonitasoft.engine.api.EJB3ServerAPI;
import org.bonitasoft.engine.api.HTTPServerAPI;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.PlatformCommandAPI;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.api.TCPServerAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.impl.LocalServerAPIFactory;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.util.APITypeManager;

public class PlatformAPIAccessor {
    private static ServerAPI getServerAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ApiAccessType apiType = APITypeManager.getAPIType();
        Map<String, String> parameters = null;
        switch (apiType) {
            case LOCAL: {
                return LocalServerAPIFactory.getServerAPI();
            }
            case EJB3: {
                parameters = APITypeManager.getAPITypeParameters();
                return new EJB3ServerAPI(parameters);
            }
            case EJB2: {
                parameters = APITypeManager.getAPITypeParameters();
                return new EJB2ServerAPI(parameters);
            }
            case HTTP: {
                parameters = APITypeManager.getAPITypeParameters();
                return new HTTPServerAPI(parameters);
            }
            case TCP: {
                parameters = APITypeManager.getAPITypeParameters();
                return new TCPServerAPI(parameters);
            }
        }
        throw new UnknownAPITypeException("Unsupported API Type: " + (Object)((Object)apiType));
    }

    public static void refresh() {
        APITypeManager.refresh();
    }

    public static PlatformLoginAPI getPlatformLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformLoginAPI.class);
    }

    private static <T> T getAPI(Class<T> clazz, PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = PlatformAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI, (Session)session);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    private static <T> T getAPI(Class<T> clazz) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = PlatformAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    public static PlatformAPI getPlatformAPI(PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformAPI.class, session);
    }

    public static PlatformCommandAPI getPlatformCommandAPI(PlatformSession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getAPI(PlatformCommandAPI.class, session);
    }
}

