/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.home.BonitaHomeClient;
import org.bonitasoft.engine.io.PropertiesManager;

public class APITypeManager {
    private static final String API_TYPE = "org.bonitasoft.engine.api-type";
    private static final BonitaHomeClient bonitaHome = BonitaHomeClient.getInstance();
    private static ApiAccessType apiAccessType = null;
    private static Map<String, String> apiTypeParameters = null;

    public static ApiAccessType getAPIType() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        if (apiAccessType == null) {
            String apiType = APITypeManager.getProperty(API_TYPE);
            if (ApiAccessType.LOCAL.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.LOCAL;
            } else if (ApiAccessType.EJB3.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.EJB3;
            } else if (ApiAccessType.EJB2.name().equalsIgnoreCase(apiType)) {
                apiAccessType = ApiAccessType.EJB2;
            } else if (apiType.equalsIgnoreCase(ApiAccessType.HTTP.name())) {
                apiAccessType = ApiAccessType.HTTP;
            } else if (apiType.equalsIgnoreCase(ApiAccessType.TCP.name())) {
                apiAccessType = ApiAccessType.TCP;
            } else {
                throw new UnknownAPITypeException("Invalid API type: " + apiType);
            }
        }
        return apiAccessType;
    }

    public static void setAPITypeAndParams(ApiAccessType type, Map<String, String> parameters) {
        apiAccessType = type;
        if (!ApiAccessType.LOCAL.equals((Object)type)) {
            apiTypeParameters = new HashMap<String, String>();
            apiTypeParameters.putAll(parameters);
        }
    }

    private static String getProperty(String propertyName) throws BonitaHomeNotSetException, ServerAPIException {
        Properties properties = APITypeManager.getProperties();
        return properties.getProperty(propertyName);
    }

    private static Properties getProperties() throws BonitaHomeNotSetException, ServerAPIException {
        String bonitaHomePath = bonitaHome.getBonitaHomeClientFolder();
        String fileName = bonitaHomePath + File.separatorChar + "conf" + File.separatorChar + "bonita-client.properties";
        try {
            return PropertiesManager.getProperties((String)fileName);
        }
        catch (IOException ioe) {
            throw new ServerAPIException((Throwable)ioe);
        }
    }

    public static Map<String, String> getAPITypeParameters() throws BonitaHomeNotSetException, ServerAPIException {
        if (apiTypeParameters == null) {
            Properties properties = APITypeManager.getProperties();
            apiTypeParameters = new HashMap<Object, Object>(properties);
            apiTypeParameters.remove(API_TYPE);
        }
        return apiTypeParameters;
    }

    public static void refresh() {
        apiAccessType = null;
        apiTypeParameters = null;
        bonitaHome.refreshBonitaHome();
    }
}

