/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.util.BitSet;

public class NullCheckingUtil {
    public static void checkArgsNotNull(Object ... params) {
        NullCheckingUtil.checkArgsNotNull(1, params);
    }

    private static void checkArgsNotNull(int offset, Object ... params) {
        NullCheckResult result = NullCheckingUtil.findNull(params);
        if (result.hasNull()) {
            StackTraceElement callerSTE = NullCheckingUtil.getCaller(offset + 1);
            String className = callerSTE.getClassName();
            String methodName = callerSTE.getMethodName();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < result.getSize(); ++i) {
                if (result.isNull(i)) {
                    sb.append("null");
                } else {
                    sb.append(params[i].getClass().getName());
                }
                if (i >= result.getSize() - 1) continue;
                sb.append(", ");
            }
            StringBuilder messageStb = new StringBuilder("Some parameters are null in ");
            messageStb.append(className);
            messageStb.append('.');
            messageStb.append(methodName);
            messageStb.append("(): ");
            messageStb.append(sb.toString());
            throw new IllegalArgumentException(messageStb.toString());
        }
    }

    public static NullCheckResult findNull(Object ... params) {
        if (params == null) {
            BitSet bitSet = new BitSet(1);
            bitSet.set(0);
            return new NullCheckResult(bitSet, 1);
        }
        BitSet bitSet = new BitSet(params.length);
        for (int i = 0; i < params.length; ++i) {
            bitSet.set(i, params[i] == null);
        }
        return new NullCheckResult(bitSet, params.length);
    }

    public static StackTraceElement getCaller(int offset) {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        StackTraceElement callerSTE = null;
        for (int i = 0; i < stes.length - offset - 1; ++i) {
            if (!stes[i].getClassName().equals(NullCheckingUtil.class.getName()) || !stes[i].getMethodName().equals("getCaller")) continue;
            callerSTE = stes[i + 1 + offset];
            break;
        }
        NullCheckingUtil.badStateIfNull(callerSTE, "Ouch! Can't get the stack trace back to the caller of this method!");
        return callerSTE;
    }

    public static void badStateIfNull(Object valueToCheck, String msg) {
        NullCheckingUtil.badStateIfTrue(valueToCheck == null, msg);
    }

    public static void badStateIfTrue(boolean valueToCheck, String msg) {
        if (valueToCheck) {
            throw new IllegalStateException(msg);
        }
    }

    public static class NullCheckResult {
        private final int size;
        private final BitSet bitSet;

        NullCheckResult(BitSet bitSet, int size) {
            this.bitSet = bitSet;
            this.size = size;
        }

        public boolean hasNull() {
            return this.bitSet.cardinality() != 0;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isNull(int i) {
            return this.bitSet.get(i);
        }
    }
}

