/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.home;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.bonitasoft.engine.commons.io.IOUtil;

public class Folder {
    private final File folder;

    public Folder(File folder) throws IOException {
        if (folder == null) {
            throw new IOException("Folder is null");
        }
        this.folder = folder;
    }

    public Folder(Folder folder, String subFolder) throws IOException {
        if (folder == null) {
            throw new IOException("Folder is null");
        }
        this.folder = new File(folder.getFile(), subFolder);
    }

    public File getFile() {
        return this.folder;
    }

    private void checkFolderExists() throws IOException {
        if (!this.folder.exists()) {
            throw new IOException("Folder denoted by path " + this.folder.getAbsolutePath() + " does not exist.");
        }
        if (!this.folder.isDirectory()) {
            throw new IOException("Folder denoted by path " + this.folder.getAbsolutePath() + " is not a folder.");
        }
    }

    public void delete() throws IOException {
        this.checkFolderExists();
        IOUtil.deleteDir(this.folder);
    }

    public File getFile(String name) throws IOException {
        this.checkFolderExists();
        return new File(this.folder, name);
    }

    public File newFile(String name) throws IOException {
        this.checkFolderExists();
        File newFile = new File(this.folder, name);
        if (!newFile.createNewFile()) {
            throw new IOException("File " + newFile.getAbsolutePath() + " cannot be created");
        }
        return newFile;
    }

    public void create() throws IOException {
        if (!this.folder.getParentFile().exists()) {
            throw new IOException("Folder denoted by path " + this.folder.getAbsolutePath() + " cannot be created as its parent does not exist.");
        }
        if (!this.folder.getParentFile().isDirectory()) {
            throw new IOException("Folder denoted by path " + this.folder.getAbsolutePath() + " cannot be created as its parent is not a folder.");
        }
        this.folder.mkdir();
    }

    public void copyTo(Folder destFolder) throws IOException {
        this.checkFolderExists();
        destFolder.create();
        FileUtils.copyDirectory((File)this.getFile(), (File)destFolder.getFile());
    }

    public Map<String, byte[]> listFilesAsResources() throws IOException {
        this.checkFolderExists();
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        File[] files = this.folder.listFiles((FileFilter)FileFileFilter.FILE);
        if (files != null) {
            for (File file : files) {
                resources.put(file.getName(), this.getFileContent(file));
            }
        }
        return resources;
    }

    protected byte[] getFileContent(File file) throws IOException {
        return IOUtil.getAllContentFrom(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Folder{folder=");
        sb.append(this.folder);
        sb.append(" --- exists:");
        sb.append(this.folder.exists());
        sb.append(" --- is directory:");
        sb.append(this.folder.isDirectory());
        sb.append('}');
        return sb.toString();
    }

    public boolean exists() {
        return this.folder.exists();
    }

    public URI toURI() throws IOException {
        this.checkFolderExists();
        return this.folder.toURI();
    }

    public Folder createIfNotExists() throws IOException {
        if (!this.folder.exists()) {
            this.create();
        }
        return this;
    }

    public void createAsTemporaryFolder() {
        IOUtil.createTempDirectory(this.folder.toURI());
    }
}

