/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanProperty {
    private static final Logger log = LoggerFactory.getLogger(BooleanProperty.class);
    private final String displayName;
    private final String propertyKey;
    private final boolean propertyValue;

    public BooleanProperty(String displayName, String propertyKey, boolean defaultValue) {
        this.propertyKey = propertyKey;
        this.displayName = displayName;
        this.propertyValue = this.initBooleanProperty(defaultValue);
    }

    boolean initBooleanProperty(boolean dynamicPermissionsEnabled) {
        boolean enabled = Boolean.parseBoolean(System.getProperty(this.propertyKey, System.getenv().getOrDefault(this.envProperty(), String.valueOf(dynamicPermissionsEnabled))));
        log.info("{} {}, you may {} it using env property {} or System property -D{} [=true/false]", new Object[]{this.displayName, enabled ? "enabled" : "disabled", enabled ? "disable" : "enable", this.envProperty(), this.propertyKey});
        return enabled;
    }

    private String envProperty() {
        return this.propertyKey.toUpperCase().replace(".", "_").replaceAll("-", "");
    }

    public boolean isEnabled() {
        return this.propertyValue;
    }
}

