/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.category;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.core.category.model.builder.SProcessCategoryMappingBuilder;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;

public class RemoveProcessDefinitionsOfCategory
implements TransactionContent {
    private final CategoryService categoryService;
    private final SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder;
    private final long categoryId;
    private final long processDefinitionId;

    public RemoveProcessDefinitionsOfCategory(CategoryService categoryService, SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder, long categoryId) {
        this.categoryService = categoryService;
        this.sProcessCategoryMappingBuilder = sProcessCategoryMappingBuilder;
        this.categoryId = categoryId;
        this.processDefinitionId = -1L;
    }

    public RemoveProcessDefinitionsOfCategory(long processDefinitionId, SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder, CategoryService categoryService) {
        this.processDefinitionId = processDefinitionId;
        this.sProcessCategoryMappingBuilder = sProcessCategoryMappingBuilder;
        this.categoryService = categoryService;
        this.categoryId = -1L;
    }

    @Override
    public void execute() throws SBonitaException {
        List<SProcessCategoryMapping> processCategoryMappings;
        long deletedProcessCategoryMappings;
        FilterOption filterOption = this.categoryId != -1L ? new FilterOption(SProcessCategoryMapping.class, this.sProcessCategoryMappingBuilder.getCategoryIdKey(), this.categoryId) : new FilterOption(SProcessCategoryMapping.class, this.sProcessCategoryMappingBuilder.getProcessIdKey(), this.processDefinitionId);
        OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, this.sProcessCategoryMappingBuilder.getIdKey(), OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(order), Collections.singletonList(filterOption), null);
        while ((deletedProcessCategoryMappings = this.categoryService.deleteProcessCategoryMappings(processCategoryMappings = this.categoryService.searchProcessCategoryMappings(queryOptions))) > 0L) {
        }
    }
}

