/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.io.Serializable;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;

public class GetLastArchivedProcessInstance
implements TransactionContentWithResult<ArchivedProcessInstance> {
    private ArchivedProcessInstance processInstance;
    private final ProcessInstanceService processInstanceService;
    private final long processInstanceId;
    private final SearchEntitiesDescriptor searchEntitiesDescriptor;

    public GetLastArchivedProcessInstance(ProcessInstanceService processInstanceService, long processInstanceId, SearchEntitiesDescriptor searchEntitiesDescriptor) {
        this.processInstanceService = processInstanceService;
        this.processInstanceId = processInstanceId;
        this.searchEntitiesDescriptor = searchEntitiesDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 2);
        searchOptionsBuilder.sort("archiveDate", Order.DESC);
        searchOptionsBuilder.sort("endDate", Order.DESC);
        searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(this.processInstanceId));
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(this.processInstanceService, this.searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptionsBuilder.done());
        searchArchivedProcessInstances.execute();
        try {
            this.processInstance = (ArchivedProcessInstance)searchArchivedProcessInstances.getResult().getResult().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SProcessInstanceNotFoundException(this.processInstanceId);
        }
    }

    @Override
    public ArchivedProcessInstance getResult() {
        return this.processInstance;
    }
}

