/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.event.trigger.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.TextDataDefinition;
import org.bonitasoft.engine.bpm.data.XMLDataDefinition;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCorrelationDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SCorrelationDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SEventTriggerDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilder;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public class SMessageEventTriggerDefinitionImpl
extends SEventTriggerDefinitionImpl
implements SMessageEventTriggerDefinition {
    private static final long serialVersionUID = 4603391860834299674L;
    private String messageName;
    private final List<SCorrelationDefinition> correlations;

    public SMessageEventTriggerDefinitionImpl(String name, List<SCorrelationDefinition> correlations) {
        this.messageName = name;
        this.correlations = correlations;
    }

    public SMessageEventTriggerDefinitionImpl() {
        this.correlations = new ArrayList<SCorrelationDefinition>(1);
    }

    public SMessageEventTriggerDefinitionImpl(SCatchMessageEventTriggerDefinition trigger) {
        this.messageName = trigger.getMessageName();
        this.correlations = trigger.getCorrelations();
    }

    public SMessageEventTriggerDefinitionImpl(MessageEventTriggerDefinition messageEventTrigger, SDataDefinitionBuilders sDataDefinitionBuilder, SExpressionBuilders sExpressionBuilders) {
        this.messageName = messageEventTrigger.getMessageName();
        this.correlations = new ArrayList<SCorrelationDefinition>(messageEventTrigger.getCorrelations().size());
        for (CorrelationDefinition correlation : messageEventTrigger.getCorrelations()) {
            this.correlations.add(new SCorrelationDefinitionImpl(ServerModelConvertor.convertExpression(sExpressionBuilders, correlation.getKey()), ServerModelConvertor.convertExpression(sExpressionBuilders, correlation.getValue())));
        }
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public List<SCorrelationDefinition> getCorrelations() {
        return Collections.unmodifiableList(this.correlations);
    }

    public void setMessageName(String name) {
        this.messageName = name;
    }

    public void addCorrelation(SCorrelationDefinition correlation) {
        this.correlations.add(correlation);
    }

    protected SDataDefinition buildSDataDefinition(DataDefinition dataDefinition, SDataDefinitionBuilders dataDefinitionBuilders, SExpressionBuilders sExpressionBuilders) {
        if (this.isXMLDataDefinition(dataDefinition)) {
            XMLDataDefinition xmlDataDef = (XMLDataDefinition)dataDefinition;
            SXMLDataDefinitionBuilder xmlDataDefinitionBuilder = dataDefinitionBuilders.getXMLDataDefinitionBuilder();
            xmlDataDefinitionBuilder.createNewXMLData(this.messageName).setElement(xmlDataDef.getElement()).setNamespace(xmlDataDef.getNamespace());
            xmlDataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(sExpressionBuilders, dataDefinition.getDefaultValueExpression()));
            xmlDataDefinitionBuilder.setDescription(dataDefinition.getDescription());
            xmlDataDefinitionBuilder.setTransient(dataDefinition.isTransientData());
            return xmlDataDefinitionBuilder.done();
        }
        SDataDefinitionBuilder dataDefinitionBuilder = dataDefinitionBuilders.getDataDefinitionBuilder();
        if (this.isTextDataDefinition(dataDefinition)) {
            TextDataDefinition textDataDefinition = (TextDataDefinition)dataDefinition;
            dataDefinitionBuilder.createNewTextData(dataDefinition.getName()).setAsLongText(textDataDefinition.isLongText());
        } else {
            dataDefinitionBuilder.createNewInstance(dataDefinition.getName(), dataDefinition.getClassName());
        }
        dataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(sExpressionBuilders, dataDefinition.getDefaultValueExpression()));
        dataDefinitionBuilder.setDescription(dataDefinition.getDescription());
        dataDefinitionBuilder.setTransient(dataDefinition.isTransientData());
        return dataDefinitionBuilder.done();
    }

    private boolean isXMLDataDefinition(DataDefinition dataDefinition) {
        return dataDefinition instanceof XMLDataDefinition;
    }

    private boolean isTextDataDefinition(DataDefinition dataDefinition) {
        return dataDefinition instanceof TextDataDefinition;
    }

    @Override
    public SEventTriggerType getEventTriggerType() {
        return SEventTriggerType.MESSAGE;
    }
}

