/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.document.mapping.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.core.process.document.mapping.DocumentMappingService;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingCreationException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingDeletionException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingNotFoundException;
import org.bonitasoft.engine.core.process.document.mapping.model.SDocumentMapping;
import org.bonitasoft.engine.core.process.document.mapping.model.archive.SADocumentMapping;
import org.bonitasoft.engine.core.process.document.mapping.model.archive.builder.SADocumentMappingBuilder;
import org.bonitasoft.engine.core.process.document.mapping.model.builder.SDocumentMappingBuilderAccessor;
import org.bonitasoft.engine.core.process.document.mapping.model.builder.SDocumentMappingUpdateBuilder;
import org.bonitasoft.engine.core.process.document.mapping.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class DocumentMappingServiceImpl
implements DocumentMappingService {
    private static final String SUPERVISED_BY = "SupervisedBy";
    private final TechnicalLoggerService technicalLogger;
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final SDocumentMappingBuilderAccessor documentMappingBuilderAccessor;
    private final ArchiveService archiveService;

    public DocumentMappingServiceImpl(TechnicalLoggerService technicalLogger, ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, SDocumentMappingBuilderAccessor documentMappingBuilderAccessor, ArchiveService archiveService) {
        this.technicalLogger = technicalLogger;
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.documentMappingBuilderAccessor = documentMappingBuilderAccessor;
        this.archiveService = archiveService;
    }

    @Override
    public SDocumentMapping create(SDocumentMapping documentMapping) throws SDocumentMappingCreationException {
        try {
            InsertRecord insertRecord = new InsertRecord(documentMapping);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)this.eventService.getEventBuilder().createInsertEvent("DOCUMENTMAPPING").setObject(documentMapping).done();
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            return documentMapping;
        }
        catch (SRecorderException e) {
            throw new SDocumentMappingCreationException(e);
        }
    }

    @Override
    public void delete(SDocumentMapping documentMapping) throws SDocumentMappingDeletionException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(documentMapping);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)this.eventService.getEventBuilder().createDeleteEvent("DOCUMENTMAPPING").setObject(documentMapping).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw this.handleDeletionError("can't delete Document Mapping " + documentMapping, e);
        }
    }

    @Override
    public void delete(long id) throws SDocumentMappingDeletionException {
        try {
            this.delete(this.get(id));
        }
        catch (SDocumentMappingNotFoundException e) {
            throw new SDocumentMappingDeletionException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public SDocumentMapping get(long documentMappingId) throws SDocumentMappingNotFoundException {
        try {
            SDocumentMapping documentMapping = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SDocumentMapping.class, "DocumentMapping", documentMappingId));
            if (documentMapping == null) {
                throw new SDocumentMappingNotFoundException("Cannot get documentMapping with id: " + documentMappingId);
            }
            return documentMapping;
        }
        catch (SBonitaReadException e) {
            throw new SDocumentMappingNotFoundException("Cannot get documentMapping with id: " + documentMappingId, e);
        }
    }

    @Override
    public List<SDocumentMapping> getDocumentMappingsForProcessInstance(long processInstanceId, int fromIndex, int maxResults, String sortFieldName, OrderByType order) throws SDocumentMappingException {
        try {
            List<SDocumentMapping> documentMappingList = this.persistenceService.selectList(SelectDescriptorBuilder.getDocumentMappingsforProcessInstance(processInstanceId, fromIndex, maxResults, sortFieldName, order));
            if (documentMappingList == null) {
                documentMappingList = Collections.emptyList();
            }
            return documentMappingList;
        }
        catch (SBonitaReadException e) {
            throw this.handleNotFoundError("Can't get the document mappings", e);
        }
    }

    private SDocumentMappingNotFoundException handleNotFoundError(String message, Exception e) {
        if (e != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.ERROR, message, e);
        }
        return new SDocumentMappingNotFoundException(message, e);
    }

    private SDocumentMappingDeletionException handleDeletionError(String message, Exception e) {
        if (e != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.ERROR, message, e);
        }
        return new SDocumentMappingDeletionException(message, e);
    }

    @Override
    public SDocumentMapping get(long processInstanceId, String documentName) throws SDocumentMappingNotFoundException {
        try {
            SDocumentMapping docMapping = this.persistenceService.selectOne(SelectDescriptorBuilder.getDocumentByName(processInstanceId, documentName));
            if (docMapping == null) {
                throw new SDocumentMappingNotFoundException("can't find the document named " + documentName + " on process instance with id " + processInstanceId);
            }
            return docMapping;
        }
        catch (SBonitaReadException e) {
            throw this.handleNotFoundError("Can't get the document mappings", e);
        }
    }

    @Override
    public SADocumentMapping get(long processInstanceId, String documentName, long time) throws SDocumentMappingNotFoundException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            List<SADocumentMapping> docMapping = persistenceService.selectList(SelectDescriptorBuilder.getArchivedDocumentByName(processInstanceId, documentName, time));
            if (docMapping.isEmpty()) {
                throw new SDocumentMappingNotFoundException("can't find the archived document named " + documentName + " on process instance with id " + processInstanceId + " for the time " + time);
            }
            return docMapping.get(0);
        }
        catch (SBonitaReadException e) {
            throw this.handleNotFoundError("Can't get the document mappings", e);
        }
    }

    @Override
    public long getNumberOfDocumentMappingsForProcessInstance(long processInstanceId) throws SDocumentMappingException {
        try {
            return this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfDocumentMappingsforProcessInstance(processInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SDocumentMappingException("Unable to count number of documents for process instance: " + processInstanceId, e);
        }
    }

    @Override
    public SDocumentMapping update(SDocumentMapping docMapping) throws SDocumentMappingException {
        SDocumentMapping sDocumentMapping = this.get(docMapping.getProcessInstanceId(), docMapping.getDocumentName());
        this.archiveOldMappingIfNecessary(sDocumentMapping, System.currentTimeMillis());
        EntityUpdateDescriptor descriptor = this.buildUpdateDescriptor(docMapping);
        return this.updateMapping(sDocumentMapping, descriptor);
    }

    @Override
    public void archive(SDocumentMapping docMapping, long archiveDate) throws SDocumentMappingException {
        this.archiveOldMappingIfNecessary(docMapping, archiveDate);
        this.delete(docMapping);
    }

    private void archiveOldMappingIfNecessary(SDocumentMapping docMapping, long archiveDate) throws SDocumentMappingException {
        if (this.archiveService.isArchivable(SDocumentMapping.class)) {
            SADocumentMapping sArchivedDocumentMapping = this.buildMappingToArchive(docMapping);
            ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(sArchivedDocumentMapping);
            try {
                this.archiveService.recordInsert(archiveDate, insertRecord);
            }
            catch (Exception e) {
                if (this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
                    this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.ERROR, "the document mapping was not archived id=" + docMapping.getId(), e);
                }
                throw new SDocumentMappingException("Unable to archive the document with id " + docMapping.getId(), e);
            }
        }
    }

    private SADocumentMapping buildMappingToArchive(SDocumentMapping docMapping) {
        SADocumentMappingBuilder archiveBuilder = this.documentMappingBuilderAccessor.getSADocumentMappingBuilder();
        return archiveBuilder.createNewInstance(docMapping).done();
    }

    private EntityUpdateDescriptor buildUpdateDescriptor(SDocumentMapping docMapping) {
        SDocumentMappingUpdateBuilder updateBuilder = this.documentMappingBuilderAccessor.getSDocumentMappingUpdateBuilder().createNewInstance();
        updateBuilder.setDocumentAuthor(docMapping.getDocumentAuthor());
        updateBuilder.setDocumentContentFileName(docMapping.getDocumentContentFileName());
        updateBuilder.setDocumentContentMimeType(docMapping.getDocumentContentMimeType());
        updateBuilder.setDocumentCreationDate(docMapping.getDocumentCreationDate());
        updateBuilder.setDocumentStorageId(docMapping.getContentStorageId());
        updateBuilder.setDocumentURL(docMapping.getDocumentURL());
        updateBuilder.setHasContent(docMapping.documentHasContent());
        return updateBuilder.done();
    }

    private SDocumentMapping updateMapping(SDocumentMapping docMapping, EntityUpdateDescriptor descriptor) throws SDocumentMappingException {
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)docMapping, descriptor);
        try {
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventService.getEventBuilder().createUpdateEvent("DOCUMENTMAPPING").setObject(docMapping).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            return docMapping;
        }
        catch (SRecorderException e) {
            throw new SDocumentMappingException("Impossible to update document. ", e);
        }
    }

    @Override
    public long getNumberOfDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SDocumentMapping.class, queryOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SDocumentMapping> searchDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SDocumentMapping.class, queryOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        try {
            return this.persistenceService.getNumberOfEntities(SDocumentMapping.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SDocumentMapping> searchDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.searchEntity(SDocumentMapping.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long getNumberOfArchivedDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            return persistenceService.getNumberOfEntities(SADocumentMapping.class, queryOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SADocumentMapping> searchArchivedDocuments(QueryOptions queryOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            return persistenceService.searchEntity(SADocumentMapping.class, queryOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        try {
            return persistenceService.getNumberOfEntities(SADocumentMapping.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SADocumentMapping> searchArchivedDocumentsSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaSearchException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return persistenceService.searchEntity(SADocumentMapping.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public SADocumentMapping getArchivedDocument(long archivedDocumentId) throws SDocumentMappingNotFoundException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            SADocumentMapping docMapping = persistenceService.selectById(SelectDescriptorBuilder.getArchivedDocumentById(archivedDocumentId));
            if (docMapping == null) {
                throw new SDocumentMappingNotFoundException("Cannot find the archived document named with identifier: " + archivedDocumentId);
            }
            return docMapping;
        }
        catch (SBonitaReadException e) {
            throw this.handleNotFoundError("Can't get the archived document mappings", e);
        }
    }

    @Override
    public SADocumentMapping getArchivedVersionOfDocument(long documentId) throws SDocumentMappingNotFoundException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            SADocumentMapping docMapping = persistenceService.selectOne(SelectDescriptorBuilder.getArchivedVersionOdDocument(documentId));
            if (docMapping == null) {
                throw new SDocumentMappingNotFoundException("Cannot find the archived document named with identifier: " + documentId);
            }
            return docMapping;
        }
        catch (SBonitaReadException e) {
            throw this.handleNotFoundError("Can't get the archived document mappings", e);
        }
    }

    @Override
    public void delete(SADocumentMapping documentMapping) throws SDocumentMappingDeletionException {
        try {
            DeleteRecord deleteRecord = new DeleteRecord(documentMapping);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("DOCUMENTMAPPING", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)this.eventService.getEventBuilder().createDeleteEvent("DOCUMENTMAPPING").setObject(documentMapping).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw this.handleDeletionError("can't delete archived Document Mapping " + documentMapping, e);
        }
    }
}

